/*
 * Decompiled with CFR 0.152.
 */
package randoop.condition.specification;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import randoop.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.dataflow.qual.Pure;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;
import randoop.org.plumelib.util.UtilPlume;

public class Identifiers {
    private final @SignatureUnknown String receiverName;
    private final @SignatureUnknown List<@SignatureUnknown String> parameters;
    private final @SignatureUnknown String returnName;

    public Identifiers(@SignatureUnknown String receiverName, @SignatureUnknown List<@SignatureUnknown String> parameters, @SignatureUnknown String returnName) {
        this.receiverName = receiverName;
        this.parameters = parameters;
        this.returnName = returnName;
    }

    public Identifiers(@SignatureUnknown List<@SignatureUnknown String> parameters) {
        this("receiver", parameters, "result");
    }

    public Identifiers() {
        this(Collections.emptyList());
    }

    public @SignatureUnknown String getReceiverName() {
        return this.receiverName;
    }

    public @SignatureUnknown List<@SignatureUnknown String> getParameterNames() {
        return this.parameters;
    }

    public @SignatureUnknown String getReturnName() {
        return this.returnName;
    }

    public @SignatureUnknown String duplicateName() {
        HashSet<String> names = new HashSet<String>();
        for (String name : this.parameters) {
            if (names.add(name)) continue;
            return name;
        }
        if (!names.add(this.receiverName)) {
            return this.receiverName;
        }
        if (!names.add(this.returnName)) {
            return this.returnName;
        }
        return null;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @SignatureUnknown boolean equals(@SignatureUnknown Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Identifiers)) {
            return false;
        }
        Identifiers other = (Identifiers)object;
        return this.receiverName.equals(other.receiverName) && this.parameters.equals(other.parameters) && this.returnName.equals(other.returnName);
    }

    @Pure
    public @SignatureUnknown int hashCode() {
        return Objects.hash(this.receiverName, this.parameters, this.returnName);
    }

    @SideEffectFree
    public @SignatureUnknown String toString() {
        return "{ \"receiverName\": \"" + this.receiverName + "\", \"parameters\": [ \"" + UtilPlume.join((CharSequence)"\", \"", this.parameters) + "\"], \"returnName\": \"" + this.returnName + "\" }";
    }
}

