/*
 * Decompiled with CFR 0.152.
 */
package randoop.condition;

import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import randoop.compile.SequenceCompiler;
import randoop.condition.ExecutableBooleanExpression;
import randoop.condition.ExecutableSpecification;
import randoop.condition.GuardPropertyPair;
import randoop.condition.GuardThrowsPair;
import randoop.condition.RandoopSpecificationError;
import randoop.condition.ThrowsClause;
import randoop.condition.specification.Guard;
import randoop.condition.specification.Identifiers;
import randoop.condition.specification.OperationSpecification;
import randoop.condition.specification.Postcondition;
import randoop.condition.specification.Precondition;
import randoop.condition.specification.Property;
import randoop.condition.specification.ThrowsCondition;
import randoop.main.GenInputsAbstract;
import randoop.org.checkerframework.checker.signature.qual.DotSeparatedIdentifiers;
import randoop.org.checkerframework.checker.signature.qual.SignatureBottom;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.reflection.RawSignature;
import randoop.types.ClassOrInterfaceType;
import randoop.util.Log;
import randoop.util.Util;

public class SpecificationTranslator {
    private static final @SignatureUnknown String DUMMY_VARIABLE_BASE_NAME = "x";
    private @SignatureUnknown RawSignature prestateExpressionSignature;
    private final @SignatureUnknown String prestateExpressionDeclaration;
    private @SignatureUnknown RawSignature poststateExpressionSignature;
    private final @SignatureUnknown String poststateExpressionDeclarations;
    private final @SignatureUnknown Map<@SignatureUnknown String, @SignatureUnknown String> replacementMap;
    private final @SignatureUnknown SequenceCompiler compiler;

    private SpecificationTranslator(@SignatureUnknown RawSignature prestateExpressionSignature, @SignatureUnknown String prestateExpressionDeclaration, @SignatureUnknown RawSignature poststateExpressionSignature, @SignatureUnknown String poststateExpressionDeclaration, @SignatureUnknown Map<@SignatureUnknown String, @SignatureUnknown String> replacementMap, @SignatureUnknown SequenceCompiler compiler) {
        this.prestateExpressionSignature = prestateExpressionSignature;
        this.prestateExpressionDeclaration = prestateExpressionDeclaration;
        this.poststateExpressionSignature = poststateExpressionSignature;
        this.poststateExpressionDeclarations = poststateExpressionDeclaration;
        this.replacementMap = replacementMap;
        this.compiler = compiler;
    }

    static @SignatureUnknown SpecificationTranslator createTranslator(@SignatureUnknown Executable executable, @SignatureUnknown OperationSpecification specification, @SignatureUnknown SequenceCompiler compiler) {
        Identifiers identifiers = specification.getIdentifiers();
        RawSignature prestateExpressionSignature = SpecificationTranslator.getExpressionSignature(executable, false);
        RawSignature poststateExpressionSignature = SpecificationTranslator.getExpressionSignature(executable, true);
        ArrayList<String> parameterNames = new ArrayList<String>();
        if (executable instanceof Method) {
            parameterNames.add(identifiers.getReceiverName());
        }
        parameterNames.addAll(identifiers.getParameterNames());
        String prestateExpressionDeclarations = prestateExpressionSignature.getDeclarationArguments(parameterNames);
        parameterNames.add(identifiers.getReturnName());
        String poststateExpressionDeclarations = poststateExpressionSignature.getDeclarationArguments(parameterNames);
        Map<String, String> replacementMap = SpecificationTranslator.createReplacementMap(parameterNames);
        return new SpecificationTranslator(prestateExpressionSignature, prestateExpressionDeclarations, poststateExpressionSignature, poststateExpressionDeclarations, replacementMap, compiler);
    }

    private static @SignatureUnknown RawSignature getExpressionSignature(@SignatureUnknown Executable executable, @SignatureUnknown boolean postState) {
        boolean isMethod = executable instanceof Method;
        Class<?> declaringClass = executable.getDeclaringClass();
        Class<?> receiverType = isMethod ? declaringClass : null;
        Class<?>[] parameterTypes = executable.getParameterTypes();
        Class<?> returnType = !postState ? null : (isMethod ? ((Method)executable).getReturnType() : declaringClass);
        String packageName = SpecificationTranslator.renamedPackage(declaringClass.getPackage());
        return SpecificationTranslator.getRawSignature(packageName, receiverType, parameterTypes, returnType);
    }

    private static @SignatureUnknown RawSignature getRawSignature(@DotSeparatedIdentifiers String packageName, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> receiverType, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> @SignatureUnknown [] parameterTypes, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> returnType) {
        int shift = receiverType != null ? 1 : 0;
        int length = parameterTypes.length + shift + (returnType != null ? 1 : 0);
        Class[] expressionParameterTypes = new Class[length];
        if (receiverType != null) {
            expressionParameterTypes[0] = receiverType;
        }
        System.arraycopy(parameterTypes, 0, expressionParameterTypes, shift, parameterTypes.length);
        if (returnType != null) {
            expressionParameterTypes[expressionParameterTypes.length - 1] = returnType;
        }
        StringJoiner methodName = new StringJoiner("_");
        methodName.add("signature");
        if (receiverType != null) {
            methodName.add(receiverType.getSimpleName());
        }
        for (Class<?> parameterType : parameterTypes) {
            methodName.add(parameterType.getSimpleName());
        }
        return new RawSignature(packageName, receiverType == null ? "ClassName" : receiverType.getSimpleName(), methodName.toString(), expressionParameterTypes);
    }

    private static @DotSeparatedIdentifiers String renamedPackage(@SignatureUnknown Package aPackage) {
        if (aPackage == null) {
            return null;
        }
        String packageName = aPackage.getName();
        if (packageName.startsWith("java.")) {
            packageName = "randoop." + packageName;
        }
        return packageName;
    }

    private static @SignatureUnknown Map<@SignatureUnknown String, @SignatureUnknown String> createReplacementMap(@SignatureUnknown List<@SignatureUnknown String> parameterNames) {
        HashMap<String, String> replacementMap = new HashMap<String, String>();
        for (int i = 0; i < parameterNames.size(); ++i) {
            replacementMap.put(parameterNames.get(i), DUMMY_VARIABLE_BASE_NAME + i);
        }
        return replacementMap;
    }

    public static @SignatureUnknown ExecutableSpecification createExecutableSpecification(@SignatureUnknown Executable executable, @SignatureUnknown OperationSpecification specification, @SignatureUnknown SequenceCompiler compiler) {
        SpecificationTranslator st = SpecificationTranslator.createTranslator(executable, specification, compiler);
        return new ExecutableSpecification(st.getGuardExpressions(specification.getPreconditions()), st.getReturnConditions(specification.getPostconditions()), st.getThrowsConditions(specification.getThrowsConditions()));
    }

    private @SignatureUnknown List<@SignatureUnknown ExecutableBooleanExpression> getGuardExpressions(@SignatureUnknown List<@SignatureUnknown Precondition> preconditions) {
        ArrayList<ExecutableBooleanExpression> guardExpressions = new ArrayList<ExecutableBooleanExpression>();
        for (Precondition precondition : preconditions) {
            try {
                guardExpressions.add(this.create(precondition.getGuard()));
            }
            catch (RandoopSpecificationError e) {
                if (GenInputsAbstract.ignore_condition_compilation_error) {
                    System.out.println("Warning: discarded uncompilable guard expression: " + e.getMessage());
                    continue;
                }
                throw e;
            }
        }
        return guardExpressions;
    }

    private @SignatureUnknown ArrayList<@SignatureUnknown GuardPropertyPair> getReturnConditions(@SignatureUnknown List<@SignatureUnknown Postcondition> postconditions) {
        ArrayList<GuardPropertyPair> returnConditions = new ArrayList<GuardPropertyPair>();
        for (Postcondition postcondition : postconditions) {
            try {
                ExecutableBooleanExpression guard = this.create(postcondition.getGuard());
                ExecutableBooleanExpression property = this.create(postcondition.getProperty());
                returnConditions.add(new GuardPropertyPair(guard, property));
            }
            catch (RandoopSpecificationError e) {
                if (GenInputsAbstract.ignore_condition_compilation_error) {
                    System.out.println("Warning: discarding uncompilable poststate expression: " + e.getMessage());
                    continue;
                }
                throw e;
            }
        }
        return returnConditions;
    }

    private @SignatureUnknown ArrayList<@SignatureUnknown GuardThrowsPair> getThrowsConditions(@SignatureUnknown List<@SignatureUnknown ThrowsCondition> throwsConditions) {
        ArrayList<GuardThrowsPair> throwsPairs = new ArrayList<GuardThrowsPair>();
        for (ThrowsCondition throwsCondition : throwsConditions) {
            ClassOrInterfaceType exceptionType;
            try {
                exceptionType = (ClassOrInterfaceType)ClassOrInterfaceType.forName(throwsCondition.getExceptionTypeName());
            }
            catch (ClassNotFoundException e) {
                String msg = "Error in specification " + throwsCondition + ". Cannot find exception type: " + e.getMessage();
                Log.logPrintf("%s%n", msg);
                if (GenInputsAbstract.ignore_condition_compilation_error) continue;
                throw new RandoopSpecificationError(msg);
            }
            try {
                ExecutableBooleanExpression guard = this.create(throwsCondition.getGuard());
                ThrowsClause throwsClause = new ThrowsClause(exceptionType, throwsCondition.getDescription());
                throwsPairs.add(new GuardThrowsPair(guard, throwsClause));
            }
            catch (RandoopSpecificationError e) {
                if (GenInputsAbstract.ignore_condition_compilation_error) {
                    System.out.println("Warning: discarding uncompilable throws-expression: " + e.getMessage());
                    continue;
                }
                throw e;
            }
        }
        return throwsPairs;
    }

    private @SignatureUnknown ExecutableBooleanExpression create(@SignatureUnknown Guard expression) {
        String contractText = Util.replaceWords(expression.getConditionSource(), this.replacementMap);
        return new ExecutableBooleanExpression(this.prestateExpressionSignature, this.prestateExpressionDeclaration, expression.getConditionSource(), contractText, expression.getDescription(), this.compiler);
    }

    public @SignatureUnknown ExecutableBooleanExpression create(@SignatureUnknown Property expression) {
        String contractText = Util.replaceWords(expression.getConditionSource(), this.replacementMap);
        return new ExecutableBooleanExpression(this.poststateExpressionSignature, this.poststateExpressionDeclarations, expression.getConditionSource(), contractText, expression.getDescription(), this.compiler);
    }

    @SignatureUnknown String getPrestateExpressionDeclaration() {
        return this.prestateExpressionDeclaration;
    }

    @SignatureUnknown String getPoststateExpressionDeclarations() {
        return this.poststateExpressionDeclarations;
    }

    @SignatureUnknown RawSignature getPoststateExpressionSignature() {
        return this.poststateExpressionSignature;
    }

    @SignatureUnknown SequenceCompiler getCompiler() {
        return this.compiler;
    }

    @SignatureUnknown Map<@SignatureUnknown String, @SignatureUnknown String> getReplacementMap() {
        return this.replacementMap;
    }
}

