/*
 * Decompiled with CFR 0.152.
 */
package randoop.condition;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import randoop.com.google.gson.Gson;
import randoop.com.google.gson.GsonBuilder;
import randoop.com.google.gson.reflect.TypeToken;
import randoop.compile.SequenceCompiler;
import randoop.condition.ExecutableSpecification;
import randoop.condition.RandoopSpecificationError;
import randoop.condition.SpecificationTranslator;
import randoop.condition.specification.OperationSignature;
import randoop.condition.specification.OperationSpecification;
import randoop.org.checkerframework.checker.signature.qual.ClassGetName;
import randoop.org.checkerframework.checker.signature.qual.SignatureBottom;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.reflection.TypeNames;
import randoop.util.MultiMap;

public class SpecificationCollection {
    private final @SignatureUnknown Map<@SignatureUnknown AccessibleObject, @SignatureUnknown OperationSpecification> specificationMap;
    private final @SignatureUnknown MultiMap<@SignatureUnknown OperationSignature, @SignatureUnknown Method> signatureToMethods;
    private final @SignatureUnknown Map<@SignatureUnknown AccessibleObject, @SignatureUnknown Set<@SignatureUnknown Method>> overridden;
    private final @SignatureUnknown SequenceCompiler compiler;
    private static @SignatureUnknown TypeToken<@SignatureUnknown List<@SignatureUnknown OperationSpecification>> LIST_OF_OS_TYPE_TOKEN = new TypeToken<List<OperationSpecification>>(){};
    private @SignatureUnknown Map<@SignatureUnknown AccessibleObject, @SignatureUnknown ExecutableSpecification> getExecutableSpecificationCache;

    SpecificationCollection(@SignatureUnknown Map<@SignatureUnknown AccessibleObject, @SignatureUnknown OperationSpecification> specificationMap, @SignatureUnknown MultiMap<@SignatureUnknown OperationSignature, @SignatureUnknown Method> signatureToMethods, @SignatureUnknown Map<@SignatureUnknown AccessibleObject, @SignatureUnknown Set<@SignatureUnknown Method>> overridden) {
        this.specificationMap = specificationMap;
        this.signatureToMethods = signatureToMethods;
        this.overridden = overridden;
        this.getExecutableSpecificationCache = new HashMap<AccessibleObject, ExecutableSpecification>();
        this.compiler = new SequenceCompiler();
    }

    public static @SignatureUnknown SpecificationCollection create(@SignatureUnknown List<@SignatureUnknown Path> specificationFiles) {
        if (specificationFiles == null) {
            return null;
        }
        MultiMap<OperationSignature, Method> signatureToMethods = new MultiMap<OperationSignature, Method>();
        LinkedHashMap<AccessibleObject, OperationSpecification> specificationMap = new LinkedHashMap<AccessibleObject, OperationSpecification>();
        for (Path specificationFile : specificationFiles) {
            SpecificationCollection.readSpecificationFile(specificationFile, specificationMap, signatureToMethods);
        }
        Map<AccessibleObject, Set<Method>> overridden = SpecificationCollection.buildOverridingMap(signatureToMethods);
        return new SpecificationCollection(specificationMap, signatureToMethods, overridden);
    }

    private static @SignatureUnknown Map<@SignatureUnknown AccessibleObject, @SignatureUnknown Set<@SignatureUnknown Method>> buildOverridingMap(@SignatureUnknown MultiMap<@SignatureUnknown OperationSignature, @SignatureUnknown Method> signatureToMethods) {
        HashMap<AccessibleObject, Set<Method>> overridden = new HashMap<AccessibleObject, Set<Method>>();
        for (OperationSignature signature : signatureToMethods.keySet()) {
            Set<Method> methods = signatureToMethods.getValues(signature);
            for (Method method : methods) {
                Class<?> declaringClass = method.getDeclaringClass();
                Set<Method> parents = SpecificationCollection.findOverridden(declaringClass, methods);
                overridden.put(method, parents);
            }
        }
        return overridden;
    }

    private static @SignatureUnknown Set<@SignatureUnknown Method> findOverridden(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> classType, @SignatureUnknown Set<@SignatureUnknown Method> methods) {
        HashSet<Method> parents = new HashSet<Method>();
        for (Method method : methods) {
            Class<?> declaringClass = method.getDeclaringClass();
            if (declaringClass == classType || !declaringClass.isAssignableFrom(classType)) continue;
            parents.add(method);
        }
        return parents;
    }

    private static @SignatureUnknown AccessibleObject getAccessibleObject(@SignatureUnknown OperationSignature operation) {
        if (operation.isValid()) {
            List<@ClassGetName String> paramTypeNames = operation.getParameterTypeNames();
            Class[] argTypes = new Class[paramTypeNames.size()];
            try {
                for (int i = 0; i < argTypes.length; ++i) {
                    argTypes[i] = TypeNames.getTypeForName(paramTypeNames.get(i));
                }
                Class<?> declaringClass = TypeNames.getTypeForName(operation.getClassname());
                if (operation.isConstructor()) {
                    return declaringClass.getDeclaredConstructor(argTypes);
                }
                return declaringClass.getDeclaredMethod(operation.getName(), argTypes);
            }
            catch (Throwable e) {
                throw new RandoopSpecificationError("Could not load specification operation: " + operation, e);
            }
        }
        return null;
    }

    private static void readSpecificationFile(@SignatureUnknown Path specificationFile, @SignatureUnknown Map<@SignatureUnknown AccessibleObject, @SignatureUnknown OperationSpecification> specificationMap, @SignatureUnknown MultiMap<@SignatureUnknown OperationSignature, @SignatureUnknown Method> signatureToMethods) {
        if (specificationFile.toString().toLowerCase().endsWith(".zip")) {
            SpecificationCollection.readSpecificationZipFile(specificationFile, specificationMap, signatureToMethods);
            return;
        }
        Gson gson = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
        try (BufferedReader reader = Files.newBufferedReader(specificationFile, StandardCharsets.UTF_8);){
            List specificationList = (List)gson.fromJson((Reader)reader, LIST_OF_OS_TYPE_TOKEN.getType());
            for (OperationSpecification specification : specificationList) {
                OperationSignature operation = specification.getOperation();
                if (operation == null) {
                    throw new Error("operation is null for specification " + specification);
                }
                String duplicateName = specification.getIdentifiers().duplicateName();
                if (duplicateName != null) {
                    throw new RandoopSpecificationError("Duplicate name \"" + duplicateName + "\" in specification: " + specification);
                }
                AccessibleObject accessibleObject = SpecificationCollection.getAccessibleObject(operation);
                specificationMap.put(accessibleObject, specification);
                if (!(accessibleObject instanceof Method)) continue;
                OperationSignature signature = OperationSignature.of(accessibleObject);
                signatureToMethods.add(signature, (Method)accessibleObject);
            }
        }
        catch (IOException e) {
            throw new RandoopSpecificationError("Unable to read specification file " + specificationFile, e);
        }
        catch (RandoopSpecificationError e) {
            e.setFile(specificationFile);
            throw e;
        }
        catch (Throwable e) {
            System.out.println("Bad specification file:");
            e.printStackTrace(System.out);
            throw new RandoopSpecificationError("Bad specification file " + specificationFile, e);
        }
    }

    private static void readSpecificationZipFile(@SignatureUnknown Path specificationZipFile, final @SignatureUnknown Map<@SignatureUnknown AccessibleObject, @SignatureUnknown OperationSpecification> specificationMap, final @SignatureUnknown MultiMap<@SignatureUnknown OperationSignature, @SignatureUnknown Method> signatureToMethods) {
        Map myEmptyMap = Collections.emptyMap();
        try {
            URI uri = URI.create("jar:" + specificationZipFile.toUri().toString());
            FileSystem zipFS = FileSystems.newFileSystem(uri, myEmptyMap);
            for (Path root : zipFS.getRootDirectories()) {
                Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public @SignatureUnknown FileVisitResult visitFile(@SignatureUnknown Path file, @SignatureUnknown BasicFileAttributes attrs) throws @SignatureUnknown IOException {
                        SpecificationCollection.readSpecificationFile(file, specificationMap, signatureToMethods);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public @SignatureUnknown FileVisitResult preVisitDirectory(@SignatureUnknown Path dir, @SignatureUnknown BasicFileAttributes attrs) throws @SignatureUnknown IOException {
                        if (dir.endsWith("__MACOSX")) {
                            return FileVisitResult.SKIP_SUBTREE;
                        }
                        return super.preVisitDirectory(dir, attrs);
                    }
                });
            }
        }
        catch (IOException e) {
            throw new RandoopSpecificationError("Unable to read specification file " + specificationZipFile, e);
        }
    }

    public @SignatureUnknown ExecutableSpecification getExecutableSpecification(@SignatureUnknown Executable executable) {
        ExecutableSpecification execSpec = this.getExecutableSpecificationCache.get(executable);
        if (execSpec != null) {
            return execSpec;
        }
        OperationSpecification specification = this.specificationMap.get(executable);
        execSpec = specification == null ? new ExecutableSpecification() : SpecificationTranslator.createExecutableSpecification(executable, specification, this.compiler);
        if (executable instanceof Method) {
            Set<Method> sigSet;
            Method method = (Method)executable;
            Set<Method> parents = this.overridden.get(executable);
            if (parents == null && (sigSet = this.signatureToMethods.getValues(OperationSignature.of(method))) != null) {
                parents = SpecificationCollection.findOverridden(method.getDeclaringClass(), sigSet);
            }
            if (parents == null) {
                throw new Error("parents = null (test #2) for " + executable);
            }
            if (parents != null) {
                for (Method parent : parents) {
                    ExecutableSpecification parentExecSpec = this.getExecutableSpecification(parent);
                    execSpec.addParent(parentExecSpec);
                }
            }
        }
        this.getExecutableSpecificationCache.put(executable, execSpec);
        return execSpec;
    }
}

