/*
 * Decompiled with CFR 0.152.
 */
package randoop.condition;

import java.util.ArrayList;
import java.util.List;
import randoop.condition.ExecutableBooleanExpression;
import randoop.condition.ThrowsClause;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.test.ExpectedExceptionGenerator;
import randoop.test.ExtendGenerator;
import randoop.test.InvalidCheckGenerator;
import randoop.test.PostConditionCheckGenerator;
import randoop.test.TestCheckGenerator;

public class ExpectedOutcomeTable {
    private @SignatureUnknown boolean isEmpty = true;
    private @SignatureUnknown boolean hasSatisfiedPrecondition = false;
    private final @SignatureUnknown List<@SignatureUnknown ExecutableBooleanExpression> postConditions = new ArrayList<ExecutableBooleanExpression>();
    private final @SignatureUnknown List<@SignatureUnknown List<@SignatureUnknown ThrowsClause>> exceptionSets = new ArrayList<List<ThrowsClause>>();

    void add(@SignatureUnknown boolean guardIsSatisfied, @SignatureUnknown ExecutableBooleanExpression postcondition, @SignatureUnknown List<@SignatureUnknown ThrowsClause> throwsClauses) {
        this.isEmpty = false;
        if (guardIsSatisfied) {
            this.hasSatisfiedPrecondition = true;
            if (postcondition != null) {
                this.postConditions.add(postcondition);
            }
        }
        if (!throwsClauses.isEmpty()) {
            this.exceptionSets.add(throwsClauses);
        }
    }

    public @SignatureUnknown boolean isInvalidCall() {
        return !this.isEmpty && !this.hasSatisfiedPrecondition && this.exceptionSets.isEmpty();
    }

    public @SignatureUnknown TestCheckGenerator addPostCheckGenerator(@SignatureUnknown TestCheckGenerator gen) {
        if (this.isEmpty) {
            return gen;
        }
        if (!this.exceptionSets.isEmpty()) {
            return new ExpectedExceptionGenerator(this.exceptionSets);
        }
        if (!this.hasSatisfiedPrecondition) {
            gen = new InvalidCheckGenerator();
        }
        if (!this.postConditions.isEmpty()) {
            return new ExtendGenerator(new PostConditionCheckGenerator(this.postConditions), gen);
        }
        return gen;
    }
}

