/*
 * Decompiled with CFR 0.152.
 */
package randoop.condition;

import java.util.ArrayList;
import java.util.List;
import randoop.condition.ExecutableBooleanExpression;
import randoop.condition.ExpectedOutcomeTable;
import randoop.condition.GuardPropertyPair;
import randoop.condition.GuardThrowsPair;
import randoop.condition.ThrowsClause;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;

public class ExecutableSpecification {
    private final @SignatureUnknown List<@SignatureUnknown ExecutableBooleanExpression> preExpressions;
    private final @SignatureUnknown List<@SignatureUnknown GuardPropertyPair> guardPropertyPairs;
    private final @SignatureUnknown List<@SignatureUnknown GuardThrowsPair> guardThrowsPairs;
    private @SignatureUnknown List<@SignatureUnknown ExecutableSpecification> parentList = new ArrayList<ExecutableSpecification>();

    public ExecutableSpecification() {
        this(new ArrayList<ExecutableBooleanExpression>(), new ArrayList<GuardPropertyPair>(), new ArrayList<GuardThrowsPair>());
    }

    public ExecutableSpecification(@SignatureUnknown List<@SignatureUnknown ExecutableBooleanExpression> preExpressions, @SignatureUnknown List<@SignatureUnknown GuardPropertyPair> guardPropertyPairs, @SignatureUnknown List<@SignatureUnknown GuardThrowsPair> guardThrowsPairs) {
        this.preExpressions = preExpressions;
        this.guardPropertyPairs = guardPropertyPairs;
        this.guardThrowsPairs = guardThrowsPairs;
    }

    public @SignatureUnknown ExpectedOutcomeTable checkPrestate(@SignatureUnknown Object @SignatureUnknown [] args) {
        ExpectedOutcomeTable table = new ExpectedOutcomeTable();
        this.checkPrestate(args, table);
        for (ExecutableSpecification execSpec : this.parentList) {
            execSpec.checkPrestate(args, table);
        }
        return table;
    }

    private void checkPrestate(@SignatureUnknown Object @SignatureUnknown [] args, @SignatureUnknown ExpectedOutcomeTable table) {
        boolean preconditionCheck = this.checkPreExpressions(args);
        List<ThrowsClause> throwsClauses = this.checkGuardThrowsPairs(args);
        ExecutableBooleanExpression postCondition = this.checkGuardPropertyPairs(args);
        table.add(preconditionCheck, postCondition, throwsClauses);
    }

    private @SignatureUnknown boolean checkPreExpressions(@SignatureUnknown Object @SignatureUnknown [] args) {
        for (ExecutableBooleanExpression preCondition : this.preExpressions) {
            if (preCondition.check(args)) continue;
            return false;
        }
        return true;
    }

    private @SignatureUnknown List<@SignatureUnknown ThrowsClause> checkGuardThrowsPairs(@SignatureUnknown Object @SignatureUnknown [] args) {
        ArrayList<ThrowsClause> throwsClauses = new ArrayList<ThrowsClause>();
        for (GuardThrowsPair pair : this.guardThrowsPairs) {
            ExecutableBooleanExpression guard = pair.guard;
            if (!guard.check(args)) continue;
            throwsClauses.add(pair.throwsClause);
        }
        return throwsClauses;
    }

    private @SignatureUnknown ExecutableBooleanExpression checkGuardPropertyPairs(@SignatureUnknown Object @SignatureUnknown [] args) {
        for (GuardPropertyPair gpPair : this.guardPropertyPairs) {
            ExecutableBooleanExpression guard = gpPair.guard;
            if (!guard.check(args)) continue;
            return gpPair.property.addPrestate(args);
        }
        return null;
    }

    void addParent(@SignatureUnknown ExecutableSpecification parentExecSpec) {
        this.parentList.add(parentExecSpec);
    }

    public @SignatureUnknown boolean isEmpty() {
        if (!(this.preExpressions.isEmpty() && this.guardPropertyPairs.isEmpty() && this.guardThrowsPairs.isEmpty())) {
            return false;
        }
        for (ExecutableSpecification execSpec : this.parentList) {
            if (execSpec.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @SideEffectFree
    public @SignatureUnknown String toString() {
        return String.format("ExecutableSpecification:  preExpressions=%s  guardPropertyPairs=%s  guardThrowsPairs=%s", this.preExpressions, this.guardPropertyPairs, this.guardThrowsPairs);
    }
}

