/*
 * Decompiled with CFR 0.152.
 */
package randoop.compile;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import randoop.compile.CompileUtil;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;

class SequenceJavaFileObject
extends SimpleJavaFileObject {
    private final @SignatureUnknown String source;
    private @SignatureUnknown ByteArrayOutputStream byteStream;

    SequenceJavaFileObject(@SignatureUnknown String classFileName,  @SignatureUnknown JavaFileObject.Kind kind) {
        super(CompileUtil.toURI(classFileName), kind);
        this.source = null;
    }

    SequenceJavaFileObject(@SignatureUnknown String classFileName, @SignatureUnknown String sequenceClass) {
        super(CompileUtil.toURI(classFileName), JavaFileObject.Kind.SOURCE);
        this.source = sequenceClass;
    }

    @Override
    public @SignatureUnknown CharSequence getCharContent(@SignatureUnknown boolean ignoreEncodingErrors) throws @SignatureUnknown UnsupportedOperationException {
        if (this.source == null) {
            throw new UnsupportedOperationException("getCharContent()");
        }
        return this.source;
    }

    @Override
    public @SignatureUnknown InputStream openInputStream() {
        return new ByteArrayInputStream(this.getByteCode());
    }

    @Override
    public @SignatureUnknown OutputStream openOutputStream() {
        this.byteStream = new ByteArrayOutputStream();
        return this.byteStream;
    }

    @SignatureUnknown byte @SignatureUnknown [] getByteCode() {
        return this.byteStream.toByteArray();
    }
}

