/*
 * Decompiled with CFR 0.152.
 */
package randoop.compile;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.ToolProvider;
import randoop.Globals;
import randoop.compile.SequenceCompilerException;
import randoop.compile.SequenceJavaFileObject;
import randoop.main.RandoopBug;
import randoop.main.RandoopUsageError;
import randoop.org.checkerframework.checker.signature.qual.BinaryName;
import randoop.org.checkerframework.checker.signature.qual.BinaryNameWithoutPackage;
import randoop.org.checkerframework.checker.signature.qual.DotSeparatedIdentifiers;
import randoop.org.checkerframework.checker.signature.qual.SignatureBottom;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.plumelib.reflection.ReflectionPlume;

public class SequenceCompiler {
    private static final @SignatureUnknown String debugCompilationFailure = null;
    private final @SignatureUnknown List<@SignatureUnknown String> compilerOptions;
    private final @SignatureUnknown JavaCompiler compiler;
    private final @SignatureUnknown JavaFileManager fileManager;

    public SequenceCompiler() {
        this(new ArrayList<String>());
    }

    public SequenceCompiler(@SignatureUnknown List<@SignatureUnknown String> compilerOptions) {
        this.compilerOptions = new ArrayList<String>(compilerOptions);
        this.compilerOptions.add("-XDuseUnsharedTable");
        this.compilerOptions.add("-d");
        this.compilerOptions.add(".");
        this.compiler = ToolProvider.getSystemJavaCompiler();
        if (this.compiler == null) {
            throw new RandoopUsageError("Cannot find the Java compiler. Check that classpath includes tools.jar." + Globals.lineSep + "Classpath:" + Globals.lineSep + ReflectionPlume.classpathToString());
        }
        this.fileManager = this.compiler.getStandardFileManager(null, null, null);
    }

    public @SignatureUnknown boolean isCompilable(@SignatureUnknown String packageName, @SignatureUnknown String classname, @SignatureUnknown String javaSource) {
        DiagnosticCollector<JavaFileObject> diagnostics = new DiagnosticCollector<JavaFileObject>();
        boolean result = this.compile(packageName, classname, javaSource, diagnostics);
        Path dir = Paths.get(packageName == null ? "." : packageName.replace(".", "/"), new String[0]);
        try {
            Files.delete(dir.resolve(classname + ".class"));
        }
        catch (NoSuchFileException noSuchFileException) {
        }
        catch (IOException e) {
            System.out.printf("Unable to delete %s: %s%n", dir.resolve(classname + ".class").toAbsolutePath(), e);
        }
        if (!result && debugCompilationFailure != null && javaSource.contains(debugCompilationFailure)) {
            StringJoiner sj = new StringJoiner(Globals.lineSep);
            sj.add("isCompilable => false");
            for (Diagnostic<JavaFileObject> d : diagnostics.getDiagnostics()) {
                sj.add(d.toString());
            }
            sj.add(javaSource);
            System.out.println(sj.toString());
        }
        return result;
    }

    private void compile(@SignatureUnknown String packageName, @SignatureUnknown String classname, @SignatureUnknown String javaSource) throws @SignatureUnknown SequenceCompilerException {
        DiagnosticCollector<JavaFileObject> diagnostics = new DiagnosticCollector<JavaFileObject>();
        boolean success = this.compile(packageName, classname, javaSource, diagnostics);
        if (!success) {
            throw new SequenceCompilerException("Compilation failed", javaSource, diagnostics);
        }
    }

    private @SignatureUnknown boolean compile(@SignatureUnknown String packageName, @SignatureUnknown String classname, @SignatureUnknown String javaSource, @SignatureUnknown DiagnosticCollector<@SignatureUnknown JavaFileObject> diagnostics) {
        String classFileName = classname + ".java";
        ArrayList<SequenceJavaFileObject> sources = new ArrayList<SequenceJavaFileObject>();
        SequenceJavaFileObject source = new SequenceJavaFileObject(classFileName, javaSource);
        sources.add(source);
        JavaCompiler.CompilationTask task = this.compiler.getTask(null, this.fileManager, diagnostics, new ArrayList<String>(this.compilerOptions), null, sources);
        Boolean succeeded = task.call();
        return succeeded != null && succeeded != false;
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> compileAndLoad(@DotSeparatedIdentifiers String packageName, @BinaryNameWithoutPackage String classname, @SignatureUnknown String javaSource) throws @SignatureUnknown SequenceCompilerException {
        this.compile(packageName, classname, javaSource);
        String fqName = this.fullyQualifiedName(packageName, classname);
        File dir = new File("").getAbsoluteFile();
        return SequenceCompiler.loadClassFile(dir, fqName);
    }

    private static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> loadClassFile(@SignatureUnknown File directory, @BinaryName String className) {
        try {
            URLClassLoader cl = new URLClassLoader(new URL[]{directory.toURI().toURL()});
            Class<?> cls = cl.loadClass(className);
            return cls;
        }
        catch (ClassNotFoundException | MalformedURLException e) {
            throw new RandoopBug(e);
        }
    }

    @BinaryName String fullyQualifiedName(@DotSeparatedIdentifiers String packageName, @BinaryNameWithoutPackage String classname) {
        @BinaryName String result = (packageName == null ? "" : packageName + ".") + classname;
        return result;
    }
}

