/*
 * Decompiled with CFR 0.152.
 */
package randoop.compile;

import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import randoop.org.checkerframework.checker.signature.qual.SignatureBottom;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;

class CompileUtil {
    CompileUtil() {
    }

    static @SignatureUnknown URI toURI(@SignatureUnknown String pathString) {
        try {
            return new URI(pathString);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static void printDiagnostics(@SignatureUnknown PrintWriter out, @SignatureUnknown List<@SignatureUnknown Diagnostic<@SignatureBottom ? extends @SignatureUnknown JavaFileObject>> diagnostics) {
        for (Diagnostic<? extends JavaFileObject> diag : diagnostics) {
            if (diag == null) continue;
            if (diag.getSource() != null) {
                String sourceName = diag.getSource().toUri().toString();
                if (diag.getLineNumber() >= 0L) {
                    out.printf("Error on line %d, col %d of %s%n%s%n", diag.getLineNumber(), diag.getColumnNumber(), sourceName, diag.getMessage(null));
                    continue;
                }
                out.printf("%s%n", diag.getMessage(null));
                continue;
            }
            out.printf("%s%n", diag.getMessage(null));
        }
    }
}

