/*
 * Decompiled with CFR 0.152.
 */
package randoop.com.github.javaparser.printer;

import java.util.List;
import java.util.stream.Collectors;
import randoop.com.github.javaparser.ast.Node;
import randoop.com.github.javaparser.ast.NodeList;
import randoop.com.github.javaparser.metamodel.NodeMetaModel;
import randoop.com.github.javaparser.metamodel.PropertyMetaModel;
import randoop.com.github.javaparser.utils.Utils;

public class DotPrinter {
    private int nodeCount;
    private final boolean outputNodeType;

    public DotPrinter(boolean outputNodeType) {
        this.outputNodeType = outputNodeType;
    }

    public String output(Node node) {
        this.nodeCount = 0;
        StringBuilder output = new StringBuilder();
        output.append("digraph {");
        this.output(node, null, "root", output);
        output.append(Utils.EOL + "}");
        return output.toString();
    }

    public void output(Node node, String parentNodeName, String name, StringBuilder builder) {
        Utils.assertNotNull(node);
        NodeMetaModel metaModel = node.getMetaModel();
        List<PropertyMetaModel> allPropertyMetaModels = metaModel.getAllPropertyMetaModels();
        List attributes = allPropertyMetaModels.stream().filter(PropertyMetaModel::isAttribute).filter(PropertyMetaModel::isSingular).collect(Collectors.toList());
        List subNodes = allPropertyMetaModels.stream().filter(PropertyMetaModel::isNode).filter(PropertyMetaModel::isSingular).collect(Collectors.toList());
        List subLists = allPropertyMetaModels.stream().filter(PropertyMetaModel::isNodeList).collect(Collectors.toList());
        String ndName = this.nextNodeName();
        if (this.outputNodeType) {
            builder.append(Utils.EOL + ndName + " [label=\"" + DotPrinter.escape(name) + " (" + metaModel.getTypeName() + ")\"];");
        } else {
            builder.append(Utils.EOL + ndName + " [label=\"" + DotPrinter.escape(name) + "\"];");
        }
        if (parentNodeName != null) {
            builder.append(Utils.EOL + parentNodeName + " -> " + ndName + ";");
        }
        for (PropertyMetaModel a : attributes) {
            String attrName = this.nextNodeName();
            builder.append(Utils.EOL + attrName + " [label=\"" + DotPrinter.escape(a.getName()) + "='" + DotPrinter.escape(a.getValue(node).toString()) + "'\"];");
            builder.append(Utils.EOL + ndName + " -> " + attrName + ";");
        }
        for (PropertyMetaModel sn : subNodes) {
            Node nd = (Node)sn.getValue(node);
            if (nd == null) continue;
            this.output(nd, ndName, sn.getName(), builder);
        }
        for (PropertyMetaModel sl : subLists) {
            NodeList nl = (NodeList)sl.getValue(node);
            if (nl == null || !nl.isNonEmpty()) continue;
            String ndLstName = this.nextNodeName();
            builder.append(Utils.EOL + ndLstName + " [label=\"" + DotPrinter.escape(sl.getName()) + "\"];");
            builder.append(Utils.EOL + ndName + " -> " + ndLstName + ";");
            String slName = sl.getName().substring(0, sl.getName().length() - 1);
            for (Node nd : nl) {
                this.output(nd, ndLstName, slName, builder);
            }
        }
    }

    private String nextNodeName() {
        return "n" + this.nodeCount++;
    }

    private static String escape(String value) {
        return value.replace("\"", "\\\"");
    }
}

