/*
 * Decompiled with CFR 0.152.
 */
package randoop;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.types.Type;
import randoop.util.CheckpointingMultiMap;
import randoop.util.CheckpointingSet;
import randoop.util.IMultiMap;
import randoop.util.ISimpleSet;
import randoop.util.MultiMap;
import randoop.util.SimpleSet;

public class SubTypeSet {
    public @SignatureUnknown ISimpleSet<@SignatureUnknown Type> types;
    private @SignatureUnknown IMultiMap<@SignatureUnknown Type, @SignatureUnknown Type> subTypes;
    private @SignatureUnknown boolean supportsCheckpoints;

    public SubTypeSet(@SignatureUnknown boolean supportsCheckpoints) {
        if (supportsCheckpoints) {
            this.supportsCheckpoints = true;
            this.subTypes = new CheckpointingMultiMap<Type, Type>();
            this.types = new CheckpointingSet<Type>();
        } else {
            this.supportsCheckpoints = false;
            this.subTypes = new MultiMap<Type, Type>();
            this.types = new SimpleSet<Type>();
        }
    }

    public void mark() {
        if (!this.supportsCheckpoints) {
            throw new RuntimeException("Operation not supported.");
        }
        ((CheckpointingMultiMap)this.subTypes).mark();
        ((CheckpointingSet)this.types).mark();
    }

    public void undoLastStep() {
        if (!this.supportsCheckpoints) {
            throw new RuntimeException("Operation not supported.");
        }
        ((CheckpointingMultiMap)this.subTypes).undoToLastMark();
        ((CheckpointingSet)this.types).undoToLastMark();
    }

    public void add(@SignatureUnknown Type c) {
        if (c == null) {
            throw new IllegalArgumentException("c cannot be null.");
        }
        if (this.types.contains(c)) {
            return;
        }
        this.types.add(c);
        for (Type cls : this.subTypes.keySet()) {
            if (!cls.isAssignableFrom(c) || this.subTypes.getValues(cls).contains(c)) continue;
            this.subTypes.add(cls, c);
        }
    }

    private void addQueryType(@SignatureUnknown Type type) {
        if (type == null) {
            throw new IllegalArgumentException("c cannot be null.");
        }
        Set<Type> keySet = this.subTypes.keySet();
        if (keySet.contains(type)) {
            return;
        }
        LinkedHashSet<Type> compatibleTypes = new LinkedHashSet<Type>();
        for (Type t : this.types.getElements()) {
            if (!type.isAssignableFrom(t)) continue;
            compatibleTypes.add(t);
        }
        for (Type cls : compatibleTypes) {
            this.subTypes.add(type, cls);
        }
    }

    public @SignatureUnknown Set<@SignatureUnknown Type> getMatches(@SignatureUnknown Type type) {
        if (!this.subTypes.keySet().contains(type)) {
            this.addQueryType(type);
        }
        return Collections.unmodifiableSet(this.subTypes.getValues(type));
    }

    public @SignatureUnknown int size() {
        return this.types.size();
    }

    public @SignatureUnknown Set<@SignatureUnknown Type> getElements() {
        return this.types.getElements();
    }
}

