/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.core.internal.analysis.filter;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.BitSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jacoco.core.internal.analysis.filter.IFilter;
import org.jacoco.core.internal.analysis.filter.IFilterContext;
import org.jacoco.core.internal.analysis.filter.IFilterOutput;
import org.jacoco.core.internal.analysis.filter.KotlinGeneratedFilter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodNode;

public final class KotlinInlineFilter
implements IFilter {
    private int firstGeneratedLineNumber = -1;
    private static final Pattern LINE_INFO_PATTERN = Pattern.compile("([0-9]++)(#[0-9]++)?+(,[0-9]++)?+:([0-9]++)(,[0-9]++)?+");
    private static final Pattern FILE_INFO_PATTERN = Pattern.compile("\\+ ([0-9]++) (.++)");

    public void filter(MethodNode methodNode, IFilterContext context, IFilterOutput output) {
        if (context.getSourceDebugExtension() == null) {
            return;
        }
        if (!KotlinGeneratedFilter.isKotlinClass(context)) {
            return;
        }
        if (this.firstGeneratedLineNumber == -1) {
            this.firstGeneratedLineNumber = KotlinInlineFilter.getFirstGeneratedLineNumber(context.getSourceFileName(), context.getSourceDebugExtension());
        }
        int line = 0;
        for (AbstractInsnNode i : methodNode.instructions) {
            if (15 == i.getType()) {
                line = ((LineNumberNode)i).line;
            }
            if (line < this.firstGeneratedLineNumber) continue;
            output.ignore(i, i);
        }
    }

    private static int getFirstGeneratedLineNumber(String sourceFileName, String smap) {
        try {
            String line;
            BufferedReader br = new BufferedReader(new StringReader(smap));
            KotlinInlineFilter.expectLine(br, "SMAP");
            KotlinInlineFilter.expectLine(br, sourceFileName);
            KotlinInlineFilter.expectLine(br, "Kotlin");
            KotlinInlineFilter.expectLine(br, "*S Kotlin");
            KotlinInlineFilter.expectLine(br, "*F");
            BitSet sourceFileIds = new BitSet();
            while (!"*L".equals(line = br.readLine())) {
                br.readLine();
                Matcher m3 = FILE_INFO_PATTERN.matcher(line);
                if (!m3.matches()) {
                    throw new IllegalStateException("Unexpected SMAP line: " + line);
                }
                String fileName = m3.group(2);
                if (!fileName.equals(sourceFileName)) continue;
                sourceFileIds.set(Integer.parseInt(m3.group(1)));
            }
            if (sourceFileIds.isEmpty()) {
                throw new IllegalStateException("Unexpected SMAP FileSection");
            }
            int min2 = Integer.MAX_VALUE;
            while (!"*E".equals(line = br.readLine())) {
                Matcher m4 = LINE_INFO_PATTERN.matcher(line);
                if (!m4.matches()) {
                    throw new IllegalStateException("Unexpected SMAP line: " + line);
                }
                int inputStartLine = Integer.parseInt(m4.group(1));
                int lineFileID = Integer.parseInt(m4.group(2).substring(1));
                int outputStartLine = Integer.parseInt(m4.group(4));
                if (sourceFileIds.get(lineFileID) && inputStartLine == outputStartLine) continue;
                min2 = Math.min(outputStartLine, min2);
            }
            return min2;
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static void expectLine(BufferedReader br, String expected) throws IOException {
        String line = br.readLine();
        if (!expected.equals(line)) {
            throw new IllegalStateException("Unexpected SMAP line: " + line);
        }
    }
}

