/*
 * Decompiled with CFR 0.152.
 */
package replacecall.org.apache.bcel.verifier.statics;

import replacecall.org.apache.bcel.generic.Type;
import replacecall.org.apache.bcel.verifier.exc.AssertionViolatedException;
import replacecall.org.apache.bcel.verifier.exc.LocalVariableInfoInconsistentException;
import replacecall.org.apache.bcel.verifier.statics.DOUBLE_Upper;
import replacecall.org.apache.bcel.verifier.statics.LONG_Upper;
import replacecall.org.apache.bcel.verifier.statics.LocalVariableInfo;
import replacecall.org.checkerframework.checker.initialization.qual.Initialized;
import replacecall.org.checkerframework.checker.interning.qual.Interned;
import replacecall.org.checkerframework.checker.interning.qual.UnknownInterned;
import replacecall.org.checkerframework.checker.nullness.qual.NonNull;
import replacecall.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import replacecall.org.checkerframework.checker.signature.qual.SignatureUnknown;

public class LocalVariablesInfo {
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LocalVariableInfo @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] localVariableInfos;

    LocalVariablesInfo(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int max_locals) {
        this.localVariableInfos = new LocalVariableInfo[max_locals];
        for (int i = 0; i < max_locals; ++i) {
            this.localVariableInfos[i] = new LocalVariableInfo();
        }
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LocalVariableInfo getLocalVariableInfo(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int slot) {
        if (slot < 0 || slot >= this.localVariableInfos.length) {
            throw new AssertionViolatedException("Slot number for local variable information out of range.");
        }
        return this.localVariableInfos[slot];
    }

    public void add(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int slot, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int startPc, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int length, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type type) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LocalVariableInfoInconsistentException {
        if (slot < 0 || slot >= this.localVariableInfos.length) {
            throw new AssertionViolatedException("Slot number for local variable information out of range.");
        }
        this.localVariableInfos[slot].add(name, startPc, length, type);
        if (type == Type.LONG) {
            this.localVariableInfos[slot + 1].add(name, startPc, length, LONG_Upper.theInstance());
        }
        if (type == Type.DOUBLE) {
            this.localVariableInfos[slot + 1].add(name, startPc, length, DOUBLE_Upper.theInstance());
        }
    }
}

