/*
 * Decompiled with CFR 0.152.
 */
package replacecall.org.apache.bcel.verifier;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import replacecall.org.apache.bcel.verifier.Verifier;
import replacecall.org.apache.bcel.verifier.VerifierFactory;
import replacecall.org.apache.bcel.verifier.VerifierFactoryObserver;
import replacecall.org.checkerframework.checker.initialization.qual.Initialized;
import replacecall.org.checkerframework.checker.interning.qual.Interned;
import replacecall.org.checkerframework.checker.interning.qual.UnknownInterned;
import replacecall.org.checkerframework.checker.nullness.qual.NonNull;
import replacecall.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import replacecall.org.checkerframework.checker.signature.qual.SignatureUnknown;

public class VerifierFactoryListModel
implements VerifierFactoryObserver,
ListModel<String> {
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown List<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ListDataListener> listeners = new ArrayList<ListDataListener>();
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Set<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String> cache = new TreeSet<String>();

    public VerifierFactoryListModel() {
        VerifierFactory.attach(this);
        this.update(null);
    }

    @Override
    public synchronized void update(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String s2) {
        Verifier[] verifiers = VerifierFactory.getVerifiers();
        int num_of_verifiers = verifiers.length;
        this.cache.clear();
        for (Verifier verifier : verifiers) {
            this.cache.add(verifier.getClassName());
        }
        for (ListDataListener listener : this.listeners) {
            ListDataEvent e = new ListDataEvent(this, 0, 0, num_of_verifiers - 1);
            listener.contentsChanged(e);
        }
    }

    @Override
    public synchronized void addListDataListener(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ListDataListener l) {
        this.listeners.add(l);
    }

    @Override
    public synchronized void removeListDataListener(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ListDataListener l) {
        this.listeners.remove(l);
    }

    @Override
    public synchronized @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getSize() {
        return this.cache.size();
    }

    @Override
    public synchronized @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String getElementAt(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int index) {
        return this.cache.toArray(new String[this.cache.size()])[index];
    }
}

