/*
 * Decompiled with CFR 0.152.
 */
package replacecall.org.apache.bcel.util;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import replacecall.org.checkerframework.checker.initialization.qual.Initialized;
import replacecall.org.checkerframework.checker.interning.qual.UnknownInterned;
import replacecall.org.checkerframework.checker.nullness.qual.NonNull;
import replacecall.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import replacecall.org.checkerframework.checker.signature.qual.SignatureUnknown;

public class ModularRuntimeImage
implements Closeable {
    static final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String MODULES_PATH = File.separator + "modules";
    static final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String PACKAGES_PATH = File.separator + "packages";
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown URLClassLoader classLoader;
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown FileSystem fileSystem;

    public ModularRuntimeImage() throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        this(null, FileSystems.getFileSystem(URI.create("jrt:/")));
    }

    public ModularRuntimeImage(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String javaHome) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        Map emptyMap = Collections.emptyMap();
        Path jrePath = Paths.get(javaHome, new String[0]);
        Path jrtFsPath = jrePath.resolve("lib").resolve("jrt-fs.jar");
        this.classLoader = new URLClassLoader(new URL[]{jrtFsPath.toUri().toURL()});
        this.fileSystem = FileSystems.newFileSystem(URI.create("jrt:/"), emptyMap, (ClassLoader)this.classLoader);
    }

    private ModularRuntimeImage(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown URLClassLoader cl, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown FileSystem fs) {
        this.classLoader = cl;
        this.fileSystem = fs;
    }

    @Override
    public void close() throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        if (this.classLoader != null) {
            this.classLoader.close();
        }
        if (this.fileSystem != null) {
            this.fileSystem.close();
        }
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown List<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Path> list(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Path dirPath) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        ArrayList<Path> list = new ArrayList<Path>();
        try (DirectoryStream<Path> ds = Files.newDirectoryStream(dirPath);){
            Iterator<Path> iterator = ds.iterator();
            while (iterator.hasNext()) {
                list.add(iterator.next());
            }
        }
        return list;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown List<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Path> list(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String dirName) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        return this.list(this.fileSystem.getPath(dirName, new String[0]));
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown List<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Path> modules() throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        return this.list(MODULES_PATH);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown List<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Path> packages() throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        return this.list(PACKAGES_PATH);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown FileSystem getFileSystem() {
        return this.fileSystem;
    }
}

