/*
 * Decompiled with CFR 0.152.
 */
package replacecall.org.apache.bcel.util;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import replacecall.org.checkerframework.checker.initialization.qual.Initialized;
import replacecall.org.checkerframework.checker.interning.qual.UnknownInterned;
import replacecall.org.checkerframework.checker.nullness.qual.NonNull;
import replacecall.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import replacecall.org.checkerframework.checker.signature.qual.BinaryName;
import replacecall.org.checkerframework.checker.signature.qual.SignatureUnknown;

public class JavaWrapper {
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassLoader loader;

    private static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassLoader getClassLoader() {
        String s2 = System.getProperty("bcel.classloader");
        if (s2 == null || "".equals(s2)) {
            throw new IllegalArgumentException("The property 'bcel.classloader' must be defined");
        }
        try {
            return (ClassLoader)Class.forName(s2).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString(), e);
        }
    }

    public JavaWrapper(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassLoader loader) {
        this.loader = loader;
    }

    public JavaWrapper() {
        this(JavaWrapper.getClassLoader());
    }

    public void runMain(@BinaryName @UnknownInterned @UnknownKeyFor @NonNull @Initialized String class_name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] argv) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassNotFoundException {
        Class<?> cl = this.loader.loadClass(class_name);
        Method method = null;
        try {
            method = cl.getMethod("main", argv.getClass());
            int m3 = method.getModifiers();
            Class<?> r = method.getReturnType();
            if (!Modifier.isPublic(m3) || !Modifier.isStatic(m3) || Modifier.isAbstract(m3) || r != Void.TYPE) {
                throw new NoSuchMethodException();
            }
        }
        catch (NoSuchMethodException no) {
            System.out.println("In class " + class_name + ": public static void main(String[] argv) is not defined");
            return;
        }
        try {
            method.invoke(null, (Object[])argv);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] argv) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Exception {
        if (argv.length == 0) {
            System.out.println("Missing class name.");
            return;
        }
        String class_name = argv[0];
        String[] new_argv = new String[argv.length - 1];
        System.arraycopy(argv, 1, new_argv, 0, new_argv.length);
        JavaWrapper wrapper = new JavaWrapper();
        wrapper.runMain(class_name, new_argv);
    }
}

