/*
 * Decompiled with CFR 0.152.
 */
package replacecall.org.apache.bcel.generic;

import java.io.DataOutputStream;
import java.io.IOException;
import replacecall.org.apache.bcel.generic.ClassGenException;
import replacecall.org.apache.bcel.generic.ConstantPoolGen;
import replacecall.org.apache.bcel.generic.IndexedInstruction;
import replacecall.org.apache.bcel.generic.Instruction;
import replacecall.org.apache.bcel.generic.ReturnaddressType;
import replacecall.org.apache.bcel.generic.Type;
import replacecall.org.apache.bcel.generic.TypedInstruction;
import replacecall.org.apache.bcel.generic.Visitor;
import replacecall.org.apache.bcel.util.ByteSequence;
import replacecall.org.checkerframework.checker.initialization.qual.Initialized;
import replacecall.org.checkerframework.checker.interning.qual.Interned;
import replacecall.org.checkerframework.checker.interning.qual.UnknownInterned;
import replacecall.org.checkerframework.checker.nullness.qual.NonNull;
import replacecall.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import replacecall.org.checkerframework.checker.signature.qual.SignatureUnknown;

public class RET
extends Instruction
implements IndexedInstruction,
TypedInstruction {
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean wide;
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int index;

    RET() {
    }

    public RET(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int index) {
        super((short)169, (short)2);
        this.setIndex(index);
    }

    @Override
    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataOutputStream out) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        if (this.wide) {
            out.writeByte(196);
        }
        out.writeByte(super.getOpcode());
        if (this.wide) {
            out.writeShort(this.index);
        } else {
            out.writeByte(this.index);
        }
    }

    private void setWide() {
        boolean bl = this.wide = this.index > 255;
        if (this.wide) {
            super.setLength(4);
        } else {
            super.setLength(2);
        }
    }

    @Override
    protected void initFromFile(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ByteSequence bytes, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean wide) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        this.wide = wide;
        if (wide) {
            this.index = bytes.readUnsignedShort();
            super.setLength(4);
        } else {
            this.index = bytes.readUnsignedByte();
            super.setLength(2);
        }
    }

    @Override
    public final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getIndex() {
        return this.index;
    }

    @Override
    public final void setIndex(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int n) {
        if (n < 0) {
            throw new ClassGenException("Negative index value: " + n);
        }
        this.index = n;
        this.setWide();
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean verbose) {
        return super.toString(verbose) + " " + this.index;
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type getType(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cp) {
        return ReturnaddressType.NO_TARGET;
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Visitor v) {
        v.visitRET(this);
    }
}

