/*
 * Decompiled with CFR 0.152.
 */
package replacecall.org.apache.bcel.generic;

import replacecall.org.apache.bcel.Repository;
import replacecall.org.apache.bcel.classfile.JavaClass;
import replacecall.org.apache.bcel.generic.ReferenceType;
import replacecall.org.checkerframework.checker.initialization.qual.Initialized;
import replacecall.org.checkerframework.checker.interning.qual.Interned;
import replacecall.org.checkerframework.checker.interning.qual.UnknownInterned;
import replacecall.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import replacecall.org.checkerframework.checker.nullness.qual.NonNull;
import replacecall.org.checkerframework.checker.nullness.qual.Nullable;
import replacecall.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import replacecall.org.checkerframework.checker.signature.qual.BinaryName;
import replacecall.org.checkerframework.checker.signature.qual.SignatureUnknown;
import replacecall.org.checkerframework.dataflow.qual.Pure;

public class ObjectType
extends ReferenceType {
    private final @BinaryName @UnknownInterned @UnknownKeyFor @NonNull @Initialized String class_name;

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ObjectType getInstance(@BinaryName @UnknownInterned @UnknownKeyFor @NonNull @Initialized String class_name) {
        return new ObjectType(class_name);
    }

    public ObjectType(@BinaryName @UnknownInterned @UnknownKeyFor @NonNull @Initialized String class_name) {
        super((byte)14, "L" + class_name.replace('.', '/') + ";");
        this.class_name = class_name.replace('/', '.');
    }

    public @BinaryName @UnknownInterned @UnknownKeyFor @NonNull @Initialized String getClassName() {
        return this.class_name;
    }

    @Override
    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int hashCode() {
        return this.class_name.hashCode();
    }

    @Override
    @EnsuresNonNullIf(result=true, expression={"#1"})
    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean equals(@Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown Object type) {
        return type instanceof ObjectType ? ((ObjectType)type).class_name.equals(this.class_name) : false;
    }

    @Deprecated
    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean referencesClass() {
        try {
            JavaClass jc = Repository.lookupClass(this.class_name);
            return jc.isClass();
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @Deprecated
    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean referencesInterface() {
        try {
            JavaClass jc = Repository.lookupClass(this.class_name);
            return !jc.isClass();
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean referencesClassExact() throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassNotFoundException {
        JavaClass jc = Repository.lookupClass(this.class_name);
        return jc.isClass();
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean referencesInterfaceExact() throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassNotFoundException {
        JavaClass jc = Repository.lookupClass(this.class_name);
        return !jc.isClass();
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean subclassOf(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ObjectType superclass) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassNotFoundException {
        if (this.referencesInterfaceExact() || superclass.referencesInterfaceExact()) {
            return false;
        }
        return Repository.instanceOf(this.class_name, superclass.class_name);
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean accessibleTo(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ObjectType accessor) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassNotFoundException {
        JavaClass jc = Repository.lookupClass(this.class_name);
        if (jc.isPublic()) {
            return true;
        }
        JavaClass acc = Repository.lookupClass(accessor.class_name);
        return acc.getPackageName().equals(jc.getPackageName());
    }
}

