/*
 * Decompiled with CFR 0.152.
 */
package replacecall.org.apache.bcel.generic;

import java.io.DataOutputStream;
import java.io.IOException;
import replacecall.org.apache.bcel.Const;
import replacecall.org.apache.bcel.ExceptionConst;
import replacecall.org.apache.bcel.generic.AllocationInstruction;
import replacecall.org.apache.bcel.generic.ArrayType;
import replacecall.org.apache.bcel.generic.BasicType;
import replacecall.org.apache.bcel.generic.ExceptionThrower;
import replacecall.org.apache.bcel.generic.Instruction;
import replacecall.org.apache.bcel.generic.StackProducer;
import replacecall.org.apache.bcel.generic.Type;
import replacecall.org.apache.bcel.generic.Visitor;
import replacecall.org.apache.bcel.util.ByteSequence;
import replacecall.org.checkerframework.checker.initialization.qual.Initialized;
import replacecall.org.checkerframework.checker.interning.qual.Interned;
import replacecall.org.checkerframework.checker.interning.qual.InternedDistinct;
import replacecall.org.checkerframework.checker.interning.qual.UnknownInterned;
import replacecall.org.checkerframework.checker.nullness.qual.NonNull;
import replacecall.org.checkerframework.checker.nullness.qual.Nullable;
import replacecall.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import replacecall.org.checkerframework.checker.signature.qual.SignatureBottom;
import replacecall.org.checkerframework.checker.signature.qual.SignatureUnknown;

public class NEWARRAY
extends Instruction
implements AllocationInstruction,
ExceptionThrower,
StackProducer {
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte type;

    NEWARRAY() {
    }

    public NEWARRAY(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte type) {
        super((short)188, (short)2);
        this.type = type;
    }

    public NEWARRAY(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown BasicType type) {
        this(type.getType());
    }

    @Override
    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataOutputStream out) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        out.writeByte(super.getOpcode());
        out.writeByte(this.type);
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte getTypecode() {
        return this.type;
    }

    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type getType() {
        return new ArrayType(BasicType.getType(this.type), 1);
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean verbose) {
        return super.toString(verbose) + " " + Const.getTypeName(this.type);
    }

    @Override
    protected void initFromFile(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ByteSequence bytes, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean wide) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        this.type = bytes.readByte();
        super.setLength(2);
    }

    @Override
    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Class<@UnknownInterned @InternedDistinct @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @SignatureUnknown @SignatureBottom ?> @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getExceptions() {
        return new Class[]{ExceptionConst.NEGATIVE_ARRAY_SIZE_EXCEPTION};
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Visitor v) {
        v.visitAllocationInstruction(this);
        v.visitExceptionThrower(this);
        v.visitStackProducer(this);
        v.visitNEWARRAY(this);
    }
}

