/*
 * Decompiled with CFR 0.152.
 */
package replacecall.org.apache.bcel.generic;

import java.util.Objects;
import replacecall.org.apache.bcel.classfile.LineNumber;
import replacecall.org.apache.bcel.generic.BranchInstruction;
import replacecall.org.apache.bcel.generic.ClassGenException;
import replacecall.org.apache.bcel.generic.InstructionHandle;
import replacecall.org.apache.bcel.generic.InstructionTargeter;
import replacecall.org.checkerframework.checker.initialization.qual.Initialized;
import replacecall.org.checkerframework.checker.interning.qual.Interned;
import replacecall.org.checkerframework.checker.interning.qual.UnknownInterned;
import replacecall.org.checkerframework.checker.nullness.qual.NonNull;
import replacecall.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import replacecall.org.checkerframework.checker.signature.qual.SignatureUnknown;
import replacecall.org.checkerframework.dataflow.qual.SideEffectFree;

public class LineNumberGen
implements InstructionTargeter,
Cloneable {
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle ih;
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int src_line;

    public LineNumberGen(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle ih, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int src_line) {
        this.setInstruction(ih);
        this.setSourceLine(src_line);
    }

    @Override
    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean containsTarget(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle ih) {
        return this.ih == ih;
    }

    @Override
    public void updateTarget(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle old_ih, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle new_ih) {
        if (old_ih != this.ih) {
            throw new ClassGenException("Not targeting " + old_ih + ", but " + this.ih + "}");
        }
        this.setInstruction(new_ih);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LineNumber getLineNumber() {
        return new LineNumber(this.ih.getPosition(), this.src_line);
    }

    public void setInstruction(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle instructionHandle) {
        Objects.requireNonNull(instructionHandle, "instructionHandle");
        BranchInstruction.notifyTarget(this.ih, instructionHandle, this);
        this.ih = instructionHandle;
    }

    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Clone Not Supported");
        }
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle getInstruction() {
        return this.ih;
    }

    public void setSourceLine(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int src_line) {
        this.src_line = src_line;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getSourceLine() {
        return this.src_line;
    }
}

