/*
 * Decompiled with CFR 0.152.
 */
package replacecall.org.apache.bcel.generic;

import java.util.HashMap;
import java.util.Map;
import replacecall.org.apache.bcel.classfile.Constant;
import replacecall.org.apache.bcel.classfile.ConstantCP;
import replacecall.org.apache.bcel.classfile.ConstantClass;
import replacecall.org.apache.bcel.classfile.ConstantDouble;
import replacecall.org.apache.bcel.classfile.ConstantFieldref;
import replacecall.org.apache.bcel.classfile.ConstantFloat;
import replacecall.org.apache.bcel.classfile.ConstantInteger;
import replacecall.org.apache.bcel.classfile.ConstantInterfaceMethodref;
import replacecall.org.apache.bcel.classfile.ConstantInvokeDynamic;
import replacecall.org.apache.bcel.classfile.ConstantLong;
import replacecall.org.apache.bcel.classfile.ConstantMethodHandle;
import replacecall.org.apache.bcel.classfile.ConstantMethodType;
import replacecall.org.apache.bcel.classfile.ConstantMethodref;
import replacecall.org.apache.bcel.classfile.ConstantModule;
import replacecall.org.apache.bcel.classfile.ConstantNameAndType;
import replacecall.org.apache.bcel.classfile.ConstantPackage;
import replacecall.org.apache.bcel.classfile.ConstantPool;
import replacecall.org.apache.bcel.classfile.ConstantString;
import replacecall.org.apache.bcel.classfile.ConstantUtf8;
import replacecall.org.apache.bcel.generic.ArrayType;
import replacecall.org.apache.bcel.generic.MethodGen;
import replacecall.org.apache.bcel.generic.ObjectType;
import replacecall.org.checkerframework.checker.initialization.qual.Initialized;
import replacecall.org.checkerframework.checker.interning.qual.Interned;
import replacecall.org.checkerframework.checker.interning.qual.UnknownInterned;
import replacecall.org.checkerframework.checker.interning.qual.UsesObjectEquals;
import replacecall.org.checkerframework.checker.nullness.qual.NonNull;
import replacecall.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import replacecall.org.checkerframework.checker.signature.qual.FieldDescriptor;
import replacecall.org.checkerframework.checker.signature.qual.FullyQualifiedName;
import replacecall.org.checkerframework.checker.signature.qual.SignatureUnknown;
import replacecall.org.checkerframework.dataflow.qual.Pure;
import replacecall.org.checkerframework.dataflow.qual.SideEffectFree;

@UsesObjectEquals
public class ConstantPoolGen {
    private static final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int DEFAULT_BUFFER_SIZE = 256;
    @Deprecated
    protected @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int size;
    @Deprecated
    protected @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Constant @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] constants;
    @Deprecated
    protected @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int index = 1;
    private static final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String METHODREF_DELIM = ":";
    private static final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String IMETHODREF_DELIM = "#";
    private static final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String FIELDREF_DELIM = "&";
    private static final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String NAT_DELIM = "%";
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Map<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Index> string_table = new HashMap<String, Index>();
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Map<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Index> class_table = new HashMap<String, Index>();
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Map<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Index> utf8_table = new HashMap<String, Index>();
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Map<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Index> n_a_t_table = new HashMap<String, Index>();
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Map<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Index> cp_table = new HashMap<String, Index>();

    public ConstantPoolGen(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Constant @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] cs) {
        StringBuilder sb = new StringBuilder(256);
        this.size = Math.max(256, cs.length + 64);
        this.constants = new Constant[this.size];
        System.arraycopy(cs, 0, this.constants, 0, cs.length);
        if (cs.length > 0) {
            this.index = cs.length;
        }
        for (int i = 1; i < this.index; ++i) {
            String key;
            ConstantUtf8 u8;
            Constant s2;
            Constant c = this.constants[i];
            if (c instanceof ConstantString) {
                s2 = (ConstantString)c;
                u8 = (ConstantUtf8)this.constants[((ConstantString)s2).getStringIndex()];
                key = u8.getBytes();
                if (this.string_table.containsKey(key)) continue;
                this.string_table.put(key, new Index(i));
                continue;
            }
            if (c instanceof ConstantClass) {
                s2 = (ConstantClass)c;
                u8 = (ConstantUtf8)this.constants[((ConstantClass)s2).getNameIndex()];
                key = u8.getBytes();
                if (this.class_table.containsKey(key)) continue;
                this.class_table.put(key, new Index(i));
                continue;
            }
            if (c instanceof ConstantNameAndType) {
                ConstantNameAndType n = (ConstantNameAndType)c;
                u8 = (ConstantUtf8)this.constants[n.getNameIndex()];
                ConstantUtf8 u8_2 = (ConstantUtf8)this.constants[n.getSignatureIndex()];
                sb.append(u8.getBytes());
                sb.append(NAT_DELIM);
                sb.append(u8_2.getBytes());
                String key2 = sb.toString();
                sb.delete(0, sb.length());
                if (this.n_a_t_table.containsKey(key2)) continue;
                this.n_a_t_table.put(key2, new Index(i));
                continue;
            }
            if (c instanceof ConstantUtf8) {
                ConstantUtf8 u = (ConstantUtf8)c;
                String key3 = u.getBytes();
                if (this.utf8_table.containsKey(key3)) continue;
                this.utf8_table.put(key3, new Index(i));
                continue;
            }
            if (c instanceof ConstantCP) {
                ConstantUtf8 u82;
                String class_name;
                ConstantCP m3 = (ConstantCP)c;
                if (c instanceof ConstantInvokeDynamic) {
                    class_name = Integer.toString(((ConstantInvokeDynamic)m3).getBootstrapMethodAttrIndex());
                } else {
                    ConstantClass clazz = (ConstantClass)this.constants[m3.getClassIndex()];
                    u82 = (ConstantUtf8)this.constants[clazz.getNameIndex()];
                    class_name = u82.getBytes().replace('/', '.');
                }
                ConstantNameAndType n = (ConstantNameAndType)this.constants[m3.getNameAndTypeIndex()];
                u82 = (ConstantUtf8)this.constants[n.getNameIndex()];
                String method_name = u82.getBytes();
                u82 = (ConstantUtf8)this.constants[n.getSignatureIndex()];
                String signature = u82.getBytes();
                String delim = METHODREF_DELIM;
                if (c instanceof ConstantInterfaceMethodref) {
                    delim = IMETHODREF_DELIM;
                } else if (c instanceof ConstantFieldref) {
                    delim = FIELDREF_DELIM;
                }
                sb.append(class_name);
                sb.append(delim);
                sb.append(method_name);
                sb.append(delim);
                sb.append(signature);
                String key4 = sb.toString();
                sb.delete(0, sb.length());
                if (this.cp_table.containsKey(key4)) continue;
                this.cp_table.put(key4, new Index(i));
                continue;
            }
            if (c != null && !(c instanceof ConstantInteger) && !(c instanceof ConstantLong) && !(c instanceof ConstantFloat) && !(c instanceof ConstantDouble) && !(c instanceof ConstantMethodType) && !(c instanceof ConstantMethodHandle) && !(c instanceof ConstantModule) && !(c instanceof ConstantPackage)) assert (false) : "Unexpected constant type: " + c.getClass().getName();
        }
    }

    public ConstantPoolGen(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool cp) {
        this(cp.getConstantPool());
    }

    public ConstantPoolGen() {
        this.size = 256;
        this.constants = new Constant[this.size];
    }

    protected void adjustSize() {
        if (this.index + 3 >= this.size) {
            Constant[] cs = this.constants;
            this.size *= 2;
            this.constants = new Constant[this.size];
            System.arraycopy(cs, 0, this.constants, 0, this.index);
        }
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int lookupString(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String str) {
        Index index = this.string_table.get(str);
        return index != null ? index.index : -1;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int addString(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String str) {
        int ret = this.lookupString(str);
        if (ret != -1) {
            return ret;
        }
        int utf8 = this.addUtf8(str);
        this.adjustSize();
        ConstantString s2 = new ConstantString(utf8);
        ret = this.index;
        this.constants[this.index++] = s2;
        if (!this.string_table.containsKey(str)) {
            this.string_table.put(str, new Index(ret));
        }
        return ret;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int lookupClass(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String str) {
        Index index = this.class_table.get(str.replace('.', '/'));
        return index != null ? index.index : -1;
    }

    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int addClass_(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String clazz) {
        int ret = this.lookupClass(clazz);
        if (ret != -1) {
            return ret;
        }
        this.adjustSize();
        ConstantClass c = new ConstantClass(this.addUtf8(clazz));
        ret = this.index;
        this.constants[this.index++] = c;
        if (!this.class_table.containsKey(clazz)) {
            this.class_table.put(clazz, new Index(ret));
        }
        return ret;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int addClass(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String str) {
        return this.addClass_(str.replace('.', '/'));
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int addClass(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ObjectType type) {
        return this.addClass(type.getClassName());
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int addArrayClass(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ArrayType type) {
        return this.addClass_(type.getSignature());
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int lookupInteger(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int n) {
        for (int i = 1; i < this.index; ++i) {
            ConstantInteger c;
            if (!(this.constants[i] instanceof ConstantInteger) || (c = (ConstantInteger)this.constants[i]).getBytes() != n) continue;
            return i;
        }
        return -1;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int addInteger(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int n) {
        int ret = this.lookupInteger(n);
        if (ret != -1) {
            return ret;
        }
        this.adjustSize();
        ret = this.index;
        this.constants[this.index++] = new ConstantInteger(n);
        return ret;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int lookupFloat(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown float n) {
        int bits = Float.floatToIntBits(n);
        for (int i = 1; i < this.index; ++i) {
            ConstantFloat c;
            if (!(this.constants[i] instanceof ConstantFloat) || Float.floatToIntBits((c = (ConstantFloat)this.constants[i]).getBytes()) != bits) continue;
            return i;
        }
        return -1;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int addFloat(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown float n) {
        int ret = this.lookupFloat(n);
        if (ret != -1) {
            return ret;
        }
        this.adjustSize();
        ret = this.index;
        this.constants[this.index++] = new ConstantFloat(n);
        return ret;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int lookupUtf8(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String n) {
        Index index = this.utf8_table.get(n);
        return index != null ? index.index : -1;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int addUtf8(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String n) {
        int ret = this.lookupUtf8(n);
        if (ret != -1) {
            return ret;
        }
        this.adjustSize();
        ret = this.index;
        this.constants[this.index++] = new ConstantUtf8(n);
        if (!this.utf8_table.containsKey(n)) {
            this.utf8_table.put(n, new Index(ret));
        }
        return ret;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int lookupLong(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown long n) {
        for (int i = 1; i < this.index; ++i) {
            ConstantLong c;
            if (!(this.constants[i] instanceof ConstantLong) || (c = (ConstantLong)this.constants[i]).getBytes() != n) continue;
            return i;
        }
        return -1;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int addLong(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown long n) {
        int ret = this.lookupLong(n);
        if (ret != -1) {
            return ret;
        }
        this.adjustSize();
        ret = this.index;
        this.constants[this.index] = new ConstantLong(n);
        this.index += 2;
        return ret;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int lookupDouble(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown double n) {
        long bits = Double.doubleToLongBits(n);
        for (int i = 1; i < this.index; ++i) {
            ConstantDouble c;
            if (!(this.constants[i] instanceof ConstantDouble) || Double.doubleToLongBits((c = (ConstantDouble)this.constants[i]).getBytes()) != bits) continue;
            return i;
        }
        return -1;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int addDouble(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown double n) {
        int ret = this.lookupDouble(n);
        if (ret != -1) {
            return ret;
        }
        this.adjustSize();
        ret = this.index;
        this.constants[this.index] = new ConstantDouble(n);
        this.index += 2;
        return ret;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int lookupNameAndType(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String signature) {
        Index _index = this.n_a_t_table.get(name + NAT_DELIM + signature);
        return _index != null ? _index.index : -1;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int addNameAndType(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String signature) {
        int ret = this.lookupNameAndType(name, signature);
        if (ret != -1) {
            return ret;
        }
        this.adjustSize();
        int name_index = this.addUtf8(name);
        int signature_index = this.addUtf8(signature);
        ret = this.index;
        this.constants[this.index++] = new ConstantNameAndType(name_index, signature_index);
        String key = name + NAT_DELIM + signature;
        if (!this.n_a_t_table.containsKey(key)) {
            this.n_a_t_table.put(key, new Index(ret));
        }
        return ret;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int lookupMethodref(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String class_name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String method_name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String signature) {
        Index index = this.cp_table.get(class_name + METHODREF_DELIM + method_name + METHODREF_DELIM + signature);
        return index != null ? index.index : -1;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int lookupMethodref(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown MethodGen method) {
        return this.lookupMethodref(method.getClassName(), method.getName(), method.getSignature());
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int addMethodref(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String class_name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String method_name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String signature) {
        int ret = this.lookupMethodref(class_name, method_name, signature);
        if (ret != -1) {
            return ret;
        }
        this.adjustSize();
        int name_and_type_index = this.addNameAndType(method_name, signature);
        int class_index = this.addClass(class_name);
        ret = this.index;
        this.constants[this.index++] = new ConstantMethodref(class_index, name_and_type_index);
        String key = class_name + METHODREF_DELIM + method_name + METHODREF_DELIM + signature;
        if (!this.cp_table.containsKey(key)) {
            this.cp_table.put(key, new Index(ret));
        }
        return ret;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int addMethodref(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown MethodGen method) {
        return this.addMethodref(method.getClassName(), method.getName(), method.getSignature());
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int lookupInterfaceMethodref(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String class_name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String method_name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String signature) {
        Index index = this.cp_table.get(class_name + IMETHODREF_DELIM + method_name + IMETHODREF_DELIM + signature);
        return index != null ? index.index : -1;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int lookupInterfaceMethodref(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown MethodGen method) {
        return this.lookupInterfaceMethodref(method.getClassName(), method.getName(), method.getSignature());
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int addInterfaceMethodref(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String class_name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String method_name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String signature) {
        int ret = this.lookupInterfaceMethodref(class_name, method_name, signature);
        if (ret != -1) {
            return ret;
        }
        this.adjustSize();
        int class_index = this.addClass(class_name);
        int name_and_type_index = this.addNameAndType(method_name, signature);
        ret = this.index;
        this.constants[this.index++] = new ConstantInterfaceMethodref(class_index, name_and_type_index);
        String key = class_name + IMETHODREF_DELIM + method_name + IMETHODREF_DELIM + signature;
        if (!this.cp_table.containsKey(key)) {
            this.cp_table.put(key, new Index(ret));
        }
        return ret;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int addInterfaceMethodref(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown MethodGen method) {
        return this.addInterfaceMethodref(method.getClassName(), method.getName(), method.getSignature());
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int lookupFieldref(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String class_name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String field_name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String signature) {
        Index index = this.cp_table.get(class_name + FIELDREF_DELIM + field_name + FIELDREF_DELIM + signature);
        return index != null ? index.index : -1;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int addFieldref(@FullyQualifiedName @UnknownInterned @UnknownKeyFor @NonNull @Initialized String class_name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String field_name, @FieldDescriptor @UnknownInterned @UnknownKeyFor @NonNull @Initialized String signature) {
        int ret = this.lookupFieldref(class_name, field_name, signature);
        if (ret != -1) {
            return ret;
        }
        this.adjustSize();
        int class_index = this.addClass(class_name);
        int name_and_type_index = this.addNameAndType(field_name, signature);
        ret = this.index;
        this.constants[this.index++] = new ConstantFieldref(class_index, name_and_type_index);
        String key = class_name + FIELDREF_DELIM + field_name + FIELDREF_DELIM + signature;
        if (!this.cp_table.containsKey(key)) {
            this.cp_table.put(key, new Index(ret));
        }
        return ret;
    }

    @Pure
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Constant getConstant(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int i) {
        return this.constants[i];
    }

    public void setConstant(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int i, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Constant c) {
        this.constants[i] = c;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool getConstantPool() {
        return new ConstantPool(this.constants);
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getSize() {
        return this.index;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool getFinalConstantPool() {
        Constant[] cs = new Constant[this.index];
        System.arraycopy(this.constants, 0, cs, 0, this.index);
        return new ConstantPool(cs);
    }

    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
        StringBuilder buf = new StringBuilder();
        for (int i = 1; i < this.index; ++i) {
            buf.append(i).append(")").append(this.constants[i]).append("\n");
        }
        return buf.toString();
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int addConstant(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Constant c, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cp) {
        Constant[] constants = cp.getConstantPool().getConstantPool();
        switch (c.getTag()) {
            case 8: {
                ConstantString s2 = (ConstantString)c;
                ConstantUtf8 u8 = (ConstantUtf8)constants[s2.getStringIndex()];
                return this.addString(u8.getBytes());
            }
            case 7: {
                ConstantClass s3 = (ConstantClass)c;
                ConstantUtf8 u8 = (ConstantUtf8)constants[s3.getNameIndex()];
                return this.addClass(u8.getBytes());
            }
            case 12: {
                ConstantNameAndType n = (ConstantNameAndType)c;
                ConstantUtf8 u8 = (ConstantUtf8)constants[n.getNameIndex()];
                ConstantUtf8 u8_2 = (ConstantUtf8)constants[n.getSignatureIndex()];
                return this.addNameAndType(u8.getBytes(), u8_2.getBytes());
            }
            case 1: {
                return this.addUtf8(((ConstantUtf8)c).getBytes());
            }
            case 6: {
                return this.addDouble(((ConstantDouble)c).getBytes());
            }
            case 4: {
                return this.addFloat(((ConstantFloat)c).getBytes());
            }
            case 5: {
                return this.addLong(((ConstantLong)c).getBytes());
            }
            case 3: {
                return this.addInteger(((ConstantInteger)c).getBytes());
            }
            case 9: 
            case 10: 
            case 11: {
                ConstantCP m3 = (ConstantCP)c;
                ConstantClass clazz = (ConstantClass)constants[m3.getClassIndex()];
                ConstantNameAndType n = (ConstantNameAndType)constants[m3.getNameAndTypeIndex()];
                ConstantUtf8 u8 = (ConstantUtf8)constants[clazz.getNameIndex()];
                @FullyQualifiedName String class_name = u8.getBytes().replace('/', '.');
                u8 = (ConstantUtf8)constants[n.getNameIndex()];
                String name = u8.getBytes();
                u8 = (ConstantUtf8)constants[n.getSignatureIndex()];
                @FieldDescriptor String signature = u8.getBytes();
                switch (c.getTag()) {
                    case 11: {
                        return this.addInterfaceMethodref(class_name, name, signature);
                    }
                    case 10: {
                        return this.addMethodref(class_name, name, signature);
                    }
                    case 9: {
                        return this.addFieldref(class_name, name, signature);
                    }
                }
                throw new RuntimeException("Unknown constant type " + c);
            }
        }
        throw new RuntimeException("Unknown constant type " + c);
    }

    private static class Index {
        final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int index;

        Index(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int i) {
            this.index = i;
        }
    }
}

