/*
 * Decompiled with CFR 0.152.
 */
package replacecall.org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import replacecall.org.apache.bcel.Const;
import replacecall.org.apache.bcel.classfile.ConstantPool;
import replacecall.org.checkerframework.checker.initialization.qual.Initialized;
import replacecall.org.checkerframework.checker.interning.qual.Interned;
import replacecall.org.checkerframework.checker.interning.qual.UnknownInterned;
import replacecall.org.checkerframework.checker.nullness.qual.NonNull;
import replacecall.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import replacecall.org.checkerframework.checker.signature.qual.SignatureUnknown;
import replacecall.org.checkerframework.dataflow.qual.SideEffectFree;

public final class StackMapType
implements Cloneable {
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte type;
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int index = -1;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool;

    StackMapType(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataInput file, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        this(file.readByte(), -1, constant_pool);
        if (this.hasIndex()) {
            this.index = file.readShort();
        }
        this.constant_pool = constant_pool;
    }

    public StackMapType(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte type, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int index, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool) {
        if (type < 0 || type > 8) {
            throw new RuntimeException("Illegal type for StackMapType: " + type);
        }
        this.type = type;
        this.index = index;
        this.constant_pool = constant_pool;
    }

    public void setType(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte t) {
        if (t < 0 || t > 8) {
            throw new RuntimeException("Illegal type for StackMapType: " + t);
        }
        this.type = t;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte getType() {
        return this.type;
    }

    public void setIndex(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int t) {
        this.index = t;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getIndex() {
        return this.index;
    }

    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataOutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        file.writeByte(this.type);
        if (this.hasIndex()) {
            file.writeShort(this.getIndex());
        }
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean hasIndex() {
        return this.type == 7 || this.type == 8;
    }

    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String printIndex() {
        if (this.type == 7) {
            if (this.index < 0) {
                return ", class=<unknown>";
            }
            return ", class=" + this.constant_pool.constantToString(this.index, (byte)7);
        }
        if (this.type == 8) {
            return ", offset=" + this.index;
        }
        return "";
    }

    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
        return "(type=" + Const.getItemName(this.type) + this.printIndex() + ")";
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown StackMapType copy() {
        try {
            return (StackMapType)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool getConstantPool() {
        return this.constant_pool;
    }

    public void setConstantPool(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool) {
        this.constant_pool = constant_pool;
    }
}

