/*
 * Decompiled with CFR 0.152.
 */
package replacecall.org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import replacecall.org.apache.bcel.classfile.ConstantPool;
import replacecall.org.apache.bcel.classfile.Node;
import replacecall.org.apache.bcel.classfile.Utility;
import replacecall.org.apache.bcel.classfile.Visitor;
import replacecall.org.checkerframework.checker.initialization.qual.Initialized;
import replacecall.org.checkerframework.checker.interning.qual.Interned;
import replacecall.org.checkerframework.checker.interning.qual.UnknownInterned;
import replacecall.org.checkerframework.checker.nullness.qual.NonNull;
import replacecall.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import replacecall.org.checkerframework.checker.signature.qual.SignatureUnknown;
import replacecall.org.checkerframework.dataflow.qual.SideEffectFree;

public final class ModuleOpens
implements Cloneable,
Node {
    private final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int opens_index;
    private final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int opens_flags;
    private final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int opens_to_count;
    private final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] opens_to_index;

    ModuleOpens(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataInput file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        this.opens_index = file.readUnsignedShort();
        this.opens_flags = file.readUnsignedShort();
        this.opens_to_count = file.readUnsignedShort();
        this.opens_to_index = new int[this.opens_to_count];
        for (int i = 0; i < this.opens_to_count; ++i) {
            this.opens_to_index[i] = file.readUnsignedShort();
        }
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Visitor v) {
        v.visitModuleOpens(this);
    }

    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataOutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        file.writeShort(this.opens_index);
        file.writeShort(this.opens_flags);
        file.writeShort(this.opens_to_count);
        for (int entry : this.opens_to_index) {
            file.writeShort(entry);
        }
    }

    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
        return "opens(" + this.opens_index + ", " + this.opens_flags + ", " + this.opens_to_count + ", ...)";
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool) {
        StringBuilder buf = new StringBuilder();
        String package_name = constant_pool.constantToString(this.opens_index, (byte)20);
        buf.append(Utility.compactClassName(package_name, false));
        buf.append(", ").append(String.format("%04x", this.opens_flags));
        buf.append(", to(").append(this.opens_to_count).append("):\n");
        for (int index : this.opens_to_index) {
            String module_name = constant_pool.getConstantString(index, (byte)19);
            buf.append("      ").append(Utility.compactClassName(module_name, false)).append("\n");
        }
        return buf.substring(0, buf.length() - 1);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ModuleOpens copy() {
        try {
            return (ModuleOpens)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

