/*
 * Decompiled with CFR 0.152.
 */
package replacecall.org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Objects;
import replacecall.org.apache.bcel.Const;
import replacecall.org.apache.bcel.classfile.ClassFormatException;
import replacecall.org.apache.bcel.classfile.ConstantClass;
import replacecall.org.apache.bcel.classfile.ConstantDouble;
import replacecall.org.apache.bcel.classfile.ConstantDynamic;
import replacecall.org.apache.bcel.classfile.ConstantFieldref;
import replacecall.org.apache.bcel.classfile.ConstantFloat;
import replacecall.org.apache.bcel.classfile.ConstantInteger;
import replacecall.org.apache.bcel.classfile.ConstantInterfaceMethodref;
import replacecall.org.apache.bcel.classfile.ConstantInvokeDynamic;
import replacecall.org.apache.bcel.classfile.ConstantLong;
import replacecall.org.apache.bcel.classfile.ConstantMethodHandle;
import replacecall.org.apache.bcel.classfile.ConstantMethodType;
import replacecall.org.apache.bcel.classfile.ConstantMethodref;
import replacecall.org.apache.bcel.classfile.ConstantModule;
import replacecall.org.apache.bcel.classfile.ConstantNameAndType;
import replacecall.org.apache.bcel.classfile.ConstantPackage;
import replacecall.org.apache.bcel.classfile.ConstantString;
import replacecall.org.apache.bcel.classfile.ConstantUtf8;
import replacecall.org.apache.bcel.classfile.Node;
import replacecall.org.apache.bcel.classfile.Visitor;
import replacecall.org.apache.bcel.util.BCELComparator;
import replacecall.org.checkerframework.checker.initialization.qual.Initialized;
import replacecall.org.checkerframework.checker.interning.qual.Interned;
import replacecall.org.checkerframework.checker.interning.qual.UnknownInterned;
import replacecall.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import replacecall.org.checkerframework.checker.nullness.qual.NonNull;
import replacecall.org.checkerframework.checker.nullness.qual.Nullable;
import replacecall.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import replacecall.org.checkerframework.checker.signature.qual.SignatureUnknown;
import replacecall.org.checkerframework.dataflow.qual.Pure;
import replacecall.org.checkerframework.dataflow.qual.SideEffectFree;

public abstract class Constant
implements Cloneable,
Node {
    private static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown BCELComparator bcelComparator = new BCELComparator(){

        @Override
        public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean equals(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Object o1, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Object o2) {
            Constant THIS = (Constant)o1;
            Constant THAT = (Constant)o2;
            return Objects.equals(THIS.toString(), THAT.toString());
        }

        @Override
        public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int hashCode(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Object o) {
            Constant THIS = (Constant)o;
            return THIS.toString().hashCode();
        }
    };
    @Deprecated
    protected @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte tag;

    Constant(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte tag) {
        this.tag = tag;
    }

    @Override
    public abstract void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Visitor var1);

    public abstract void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataOutputStream var1) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException;

    public final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte getTag() {
        return this.tag;
    }

    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
        return Const.getConstantName(this.tag) + "[" + this.tag + "]";
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Constant copy() {
        try {
            return (Constant)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Clone Not Supported");
        }
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Constant readConstant(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataInput dataInput) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassFormatException {
        byte b = dataInput.readByte();
        switch (b) {
            case 7: {
                return new ConstantClass(dataInput);
            }
            case 9: {
                return new ConstantFieldref(dataInput);
            }
            case 10: {
                return new ConstantMethodref(dataInput);
            }
            case 11: {
                return new ConstantInterfaceMethodref(dataInput);
            }
            case 8: {
                return new ConstantString(dataInput);
            }
            case 3: {
                return new ConstantInteger(dataInput);
            }
            case 4: {
                return new ConstantFloat(dataInput);
            }
            case 5: {
                return new ConstantLong(dataInput);
            }
            case 6: {
                return new ConstantDouble(dataInput);
            }
            case 12: {
                return new ConstantNameAndType(dataInput);
            }
            case 1: {
                return ConstantUtf8.getInstance(dataInput);
            }
            case 15: {
                return new ConstantMethodHandle(dataInput);
            }
            case 16: {
                return new ConstantMethodType(dataInput);
            }
            case 17: {
                return new ConstantDynamic(dataInput);
            }
            case 18: {
                return new ConstantInvokeDynamic(dataInput);
            }
            case 19: {
                return new ConstantModule(dataInput);
            }
            case 20: {
                return new ConstantPackage(dataInput);
            }
        }
        throw new ClassFormatException("Invalid byte tag in constant pool: " + b);
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown BCELComparator getComparator() {
        return bcelComparator;
    }

    public static void setComparator(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown BCELComparator comparator) {
        bcelComparator = comparator;
    }

    @EnsuresNonNullIf(result=true, expression={"#1"})
    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean equals(@Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown Object obj) {
        return bcelComparator.equals(this, obj);
    }

    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int hashCode() {
        return bcelComparator.hashCode(this);
    }
}

