/*
 * main.cpp
 *
 * Testing application to show off weak references.  You must lock them to use them.
 *
 * Walker M. White
 * February 6, 2015
 */

#include <stdio.h>
#include <memory>
#include "point.h"

using namespace std;

/**
 * Main application function.
 */
int main() {
	shared_ptr<Point> p = make_shared<Point>(1.0f,2.0f,3.0f);
	weak_ptr<Point> q = p;
	printf("Reference count of %s is %ld.\n",p->toString().c_str(),p.use_count());
	
	shared_ptr<Point> value;
	
	// Must lock q to access
	value = q.lock();
	printf("Value is %s.\n", value == nullptr ? "null" : value->toString().c_str());
	value = nullptr;
	
	p = nullptr;

	// Must lock q to access
	value = q.lock();
	printf("Value is %s.\n", value == nullptr ? "null" : value->toString().c_str());
	value = nullptr;
	
	return 0;
}
