/*
 * main.cpp
 * 
 * This module shows off how pointer arithmetic works in C++.  Some functions may force
 * you to convert an array to a byte array (char*).
 *
 * Walker M. White
 * February 12, 2020
 */
#include <stdio.h>
#include <string>


using namespace std;


/**
 * Demonstrate pointer arithmetic
 *
 * Pointer arithmetic depends on the TYPE of the pointer.  
 * + 1 means + sizeof(type).
 */
int main() {
	const int ARRAY_SIZE = 16;

	// Create a byte array
	char* bytes = new char[ARRAY_SIZE];
	for(int ii = 0; ii <  ARRAY_SIZE; ii++) {
		bytes[ii] = ii;
	}

	printf("Byte at bytes[3] is %d.\n",bytes[3]);
	// This is the SAME
	printf("Byte at *(bytes+3) is %d.\n",*(bytes+3));
	
	int* asints = (int*)bytes;
	char* pos = (char*)(asints+3);
	
	printf("Byte at *(asints+3) is %d.\n",*pos);
	printf("Byte at bytes[12] is %d.\n",bytes[12]);
	
	delete[] bytes;
}