/*
 * stringfun.h
 *
 * These are the classic palindrome functions shown off in CS 1110.
 * The purpose of them is to show off how namespaces work.
 *
 * This implementation includes a namepace brace, which allows us to
 * define with out a prefix.  HOWEVER, main cannot be in the namespace
 * and so (since there is no using) it must call with the prefix.
 *
 * Walker M. White
 * February 6, 2016
 */
#include "stringfun.h"
#include <iostream>     // cout
#include <locale>       // locale, isalpha

using namespace std;    // To remove the  prefix

/** Put these definitions in the namespace */
namespace stringfun {

/** Returns: true if s is a palindrome */
bool isPalindrome(string s) {
    // Base palindrome
    if (s.size() < 2) {
        return true;
    }

    // s has at least 2 characters
    return s[0] == s[s.size()-1] && isPalindrome(s.substr(1,s.size()-2));
}

/** Returns: true if s is a palindrome paying attention only to the letters */
bool isPalindromeLoosely(string s) {
    return isPalindrome(depunct(s));
}

/** Returns: s but with everything that is not a letter removed */
string depunct(string s) {
    if (s.size() == 0) {
        return s;
    }

    locale locale;

    if (not isalpha(s[0],locale)) {
        return depunct(s.substr(1));
	}

    return s[0] + depunct(s.substr(1));
}

} // END NAMESPACE

/** Testing function (cannot be in namespace) */
int main() {
	string s = "";
	cout << "\"" << s << "\" is a palindrome: " << stringfun::isPalindrome(s) << endl;
	s = "B";
	cout << "\"" << s << "\" is a palindrome: " << stringfun::isPalindrome(s) << endl;
	s = "BB";
	cout << "\"" << s << "\" is a palindrome: " << stringfun::isPalindrome(s) << endl;
	s = "BA";
	cout << "\"" << s << "\" is a palindrome: " << stringfun::isPalindrome(s) << endl;
	s = "BOB";
	cout << "\"" << s << "\" is a palindrome: " << stringfun::isPalindrome(s) << endl;
	s = "BOA";
	cout << "\"" << s << "\" is a palindrome: " << stringfun::isPalindrome(s) << endl;
	s = "amanaplanacanalpanama";
	cout << "\"" << s << "\" is a palindrome: " << stringfun::isPalindrome(s) << endl;
	s = "a man, a plan, a canal, panama!";
	cout << "\"" << s << "\" is a palindrome: " << stringfun::isPalindrome(s) << endl;
	cout << endl;

	s = "bob";
	cout << "Depuncting \"" << s << "\" gives: " << stringfun::depunct(s) << endl;
	s = "bob111!";
	cout << "Depuncting \"" << s << "\" gives: " << stringfun::depunct(s) << endl;
	s = "?b#o#b?";
	cout << "Depuncting \"" << s << "\" gives: " << stringfun::depunct(s) << endl;
	s = "?2#3@?";
	cout << "Depuncting \"" << s << "\" gives: " << stringfun::depunct(s) << endl;
	cout << endl;

	s = "amanaplanacanalpanama";
	cout << "\"" << s << "\" is a loose palindrome: " << stringfun::isPalindromeLoosely(s) << endl;
	s = "a man, a plan, a canal, panama!";
	cout << "\"" << s << "\" is a loose palindrome: " << stringfun::isPalindromeLoosely(s) << endl;
	s = "?2#3@?";
	cout << "\"" << s << "\" is a loose palindrome: " << stringfun::isPalindromeLoosely(s) << endl;
	cout << endl;

	return 0;
}
