/*
 * temperature.h
 *
 * These are the classic temperature conversion functions shown off in CS 1110. We 
 * introduce them to show how to make a multi-file unit test in C++.
 *
 * Walker M. White
 * February 6, 2015
 */

// Prevent cyclical includes
#ifndef __TEMPERATURE__H_ 
#define __TEMPERATURE__H_

/** Temperature water freezes in centigrade */
#define FREEZING_C 0.0f

/** Temperature water freezes in fahrenheit */
#define FREEZING_F to_fahrenheit(FREEZING_C)

/** Temperature water boils in centigrade */
#define BOILING_C 100.0f

/** Temperature water boils in fahrenheit */
#define BOILING_F to_fahrenheit(BOILING_C)

/**
 * Returns x converted to centigrade
 *
 * @param x  a float measuring temperature in fahrenheit
 *
 * @return x converted to centigrade
 */
float to_centigrade(float x);

/**
 * Returns x converted to fahrenheit
 *
 * @param x  a float measuring temperature in centigrade
 *
 * @return x converted to fahrenheit
 */
float to_fahrenheit(float x);

#endif