clear;
XX = csvread('/Users/sridharan/Desktop/dump/smilie_example/wdbc.csv');
X = XX(:,3:end);
L = XX(:,2);

% X has the data, 30 coordinates per data point. Each datapoint consists of
% 3 cell nucleus and Ten real-valued features are computed for each cell nucleus: 
% 
% a) radius (mean of distances from center to points on the perimeter) 
% b) texture (standard deviation of gray-scale values) 
% c) perimeter 
% d) area 
% e) smoothness (local variation in radius lengths) 
% f) compactness (perimeter^2 / area - 1.0) 
% g) concavity (severity of concave portions of the contour) 
% h) concave points (number of concave portions of the contour) 
% i) symmetry 
% j) fractal dimension ("coastline approximation" - 1)
% 



C = cov(X); 
% compute covarnace matrix

[W,E] = eigs(C,1); 
% Find top eigenvector W  (E is the top eigenvalue) 

Y = X*W;
% Project to one dimension


% Plot and have fun

scatter(Y(find(L==0)),zeros(length(find(L==0)),1),'b');
hold on;
scatter(Y(find(L==1)),zeros(length(find(L==1)),1),'r');
figure;
scatter(Y,zeros(length(Y),1));
% figure;
% [W,E] = eigs(C,3);
% Y = X*W;
% scatter3(Y(find(L==0),1),Y(find(L==0),2),Y(find(L==0),3),'b');
% hold on;
% scatter3(Y(find(L==1),1),Y(find(L==1),2),Y(find(L==1),3),'r');
