clear;

'Load images into data matrix by vectorizing'

% Load images and convert them to vector format
for t = 1:28
    I(:,:,t) = rgb2gray(imread(['smilie',num2str(t),'.jpeg']));
    temp = I(:,:,t);
    X(t,:) = double(temp(:));
end

% now X is the data matrix and each row of X corresponds to one data point

Mu = mean(X);

% Mu is the mean vector of all the smilie faces (in vector format)

pause;

'Compute covariance matrix Sigma = cov(X)'

Sigma = cov(X);
pause;
% Matlab does the covariance calculation for you using function cov

K = 8;  % we pick the top 20 eigen vectors


'Compute projection matrix W'
[W,D] = eigs(Sigma,K);
pause;
% The above is a matlab function that returns the top 20 eigen vectors in
% matrix W and D is the diagonal matrix of the eigen values

'Compute projection'
Y = (X-repmat(Mu,[28,1]))*W;

% Here is the line that does the linear projection to lower dimension
% We are doing all the 28 ones in a batch and repmat repeats the single
% mean vector 28 times


% First column of Y is the data on first principal component, second column
% is the second principal component and so on

%The below snippet that shows the 2 dimensional scatter plot of the images
pause; 
'Display projections along with the emoji to annotate them'
pause;
scatter(Y(:,1), zeros(size(Y,1),1))
hold on
for t = 1:28
image([Y(t,1),Y(t,1)+400], [0,-250],I(:,:,t));
end
% notice that the wink images are seperated from the other ones






Str = input('Proceed to 2D? [y/n] [y]: ','s');
figure;
%The below snippet that shows the 2 dimensional scatter plot of the images
if isempty(Str)
    Str = 'y';
end

if(Str == 'y' || Str == 'Y')
    scatter(Y(:,1), Y(:,2))
    hold on
    for t = 1:28
        image([Y(t,1),Y(t,1)+600], [Y(t,2),Y(t,2)-600],I(:,:,t));
    end
end
% notice that the wink images are seperated from the other ones

