/* For writing models */
void   SVML_write_model(char *modelfile, MODEL *model, long binary);

/* For reading models. Returns 1 if file was binary format, 0 otherwise. */
long   SVML_read_model(char *modelfile, MODEL *model);

/* For reading documents. Return 1 if file was binary format, 0 otherwise. */
long   SVML_read_documents(char *docfile, DOC **docs, double **label,
													 long *totwords, long *totdoc);

/* For writing documents */
void   SVML_write_documents(char *docfile, DOC *docs, double *labels, long n_docs, long binary);

/* Returns 1 if file is binary document format */
int SVML_documents_isbinary(char *filename);

/* Internally used functions */
void   SVML_write_model_ascii(char *modelfile, MODEL *model);
void   SVML_write_model_binary(char *modelfile, MODEL *model);

void   SVML_read_model_ascii(FILE *modelfl, MODEL *model, long max_words, long ll);
void   SVML_read_model_binary(FILE *modelfl, MODEL *model);

void   SVML_read_documents_ascii(char *docfile, DOC **docs, double **label,
																 long *totwords, long *totdoc);
void   SVML_read_documents_binary(char *docfile, DOC **docs, double **label,
																	long *totwords, long *totdoc);

void   SVML_write_documents_ascii(char *docfile, DOC *docs, double *labels, long n_docs);
void   SVML_write_documents_binary(char *docfile, DOC *docs, double *labels, long n_docs);

int    parse_document(char *line, DOC *doc, double *label, 
											long int *numwords, long int max_words_doc);

void   nol_ll(char *, long *, long *, long *);
void   *my_mallocIO(size_t size);
int    space_or_null(int);
double sprod_ssIO(WORD *a, WORD *b);


