% Visualizes skeleton data, drawing lines for the links. P and R are
% locations and orientations (as 3x3 rotation matrices) for each joint. 
%
% Links is a list of pairs of joints to connect with a line.

function [ ] = showSkelWithLinks(P, R, links)
% actual visualization
SKEL_COLOR = 0*[1 0 1];
SKEL_WD = 4;

hold on
lineLen=50;
linewidth=2;

NUM_OR_LINKS = 11;

NUM_PT_LINKS = 4;

for i=1:NUM_OR_LINKS,
    xyz = P(i,:);
    x = P(i,1);
    y = P(i,2);
    z = P(i,3);
    plot3(x,y,z,'r.', 'MarkerSize',15);        
        
    curR = squeeze(R(i,:,:));
    vect = curR(:,1)*lineLen;
    vect = xyz+vect;
    xd = vect(1);
    yd = vect(2);
    zd = vect(3);
    line([x,xd],[y,yd],[z,zd],'Color','r', 'LineWidth',linewidth);
    
    vect = curR(:,2)*lineLen;
    vect = xyz+vect;
    xd = vect(1);
    yd = vect(2);
    zd = vect(3);
    line([x,xd],[y,yd],[z,zd],'Color','g', 'LineWidth',linewidth);
    
    vect = curR(:,3)*lineLen;
    vect = xyz+vect;
    xd = vect(1);
    yd = vect(2);
    zd = vect(3);
    line([x,xd],[y,yd],[z,zd],'Color','b', 'LineWidth',linewidth);    
end

for i=NUM_OR_LINKS+1:NUM_OR_LINKS+NUM_PT_LINKS,
    xyz = P(i,:);
    x=xyz(1);
    y=xyz(2);
    z=xyz(3);
    
    plot3(x,y,z,'B.','MarkerSize',15); 
end

for i = 1:size(links,1)
    P1 = P(links(i,1),:);
    P2 = P(links(i,2),:);
    
    plot3([P1(1); P2(1)],[P1(2); P2(2)],[P1(3); P2(3)],'Color',SKEL_COLOR,'LineWidth',SKEL_WD);
end
   
xlabel('x')
ylabel('y')
zlabel('z')
legend('joints','x','y','z');
hold off

axis equal;

%fprintf('figure done..\n');

end

