% Computes relative point features for the right arm
%
% These features consist of the X,Y, and Z coordinates of the shoulder,
% elbow, and hand points relative to the neck, in the coordinate axis
% defined by the torso's rotation matrix.

function relP = relPFeatForAllRightArms(P,R)

% Grab global indices for the joints we're interested in
global TORSO_IND NECK_IND R_SHOULDER_IND R_ELBOW_IND R_HAND_IND;

% Set up the base frame and base point
BASE_FRAME_IND = TORSO_IND;

BASE_P_IND = NECK_IND;

baseP = squeeze(P(:,BASE_P_IND,:));
baseFrame = squeeze(R(:,BASE_FRAME_IND,:,:));

% Extract features for the shoulder, elbow, and hand
numDat = size(P,1);
relP = zeros(numDat,3,3);

relP(:,1,:) = relativePointFeatAll(squeeze(P(:,R_SHOULDER_IND,:)),baseP,baseFrame);
relP(:,2,:) = relativePointFeatAll(squeeze(P(:,R_ELBOW_IND,:)),baseP,baseFrame);
relP(:,3,:) = relativePointFeatAll(squeeze(P(:,R_HAND_IND,:)),baseP,baseFrame);

