% Computes relative joint location features for both arms for the given
% lists of joint parameters
%
% These features consist of the X,Y, and Z coordinates of the shoulder,
% elbow, and hand points relative to the neck, in the coordinate axis
% defined by the torso's rotation matrix.

function relP = relPFeatForAllBothArms(P,R)

% Get features for each arm
relPL = relPFeatForAllLeftArms(P,R);
relPR = relPFeatForAllRightArms(P,R);

% Combine them, and reshape into a 2D matrix
relP = [relPL relPR];
relP = reshape(relP,size(relP,1),[]);