% bsxfun-style dot product. Takes the dot of the vectors in A and the
% values in B, taking the dot along the given dimension. If the dimension
% isn't given, assumes that the dot should be taken along the last
% non-singular dimension of A. 
% 
% If the dimension to dot for A is singular, attempts to permute A to a 
% valid configuration (ie if A is 100x1x3, B is 100x3x3, and dotDim is 2, 
% A would be permuted to be 100x3x1)

function dotProd = bsxDot(A,B,dotDim)

if nargin < 3
    dotDim = find(size(A) > 1,'last');
elseif size(A,dotDim) == 1
    matches = find(size(A) == size(B,dotDim));
    
    if length(matches) > 1
        fprintf(1,'bsxDot: Ambiguous which dimension to take dot over!\n');
        dotProd = [];
        return;
    end
    
    dimPerm = 1:ndims(A);
    dimPerm(dotDim) = matches;
    dimPerm(matches) = dotDim;
    
    permute(A,dimPerm);
end    

dotProd = sum(bsxfun(@times,A,B),dotDim);