% Evaluate weights from mnrfit for the given data and ground-truth classes
%
% For N classes, returns:
%
% conf: NxN confusion matrix - each row corresponds to a ground-truth
% class, each column, a predicted class, such that conf(i,j) is the number
% of cases which actually belong to class i and were predicted to belong to
% class j
%
% prec, rec: Nx1 vectors indicating precision and recall for each class

function [conf, prec, rec] = evaluateMNRClass(B,data,trueClasses)

% Use mnrval to get predicted class probabilities for each case
predClassProbs = mnrval(B,data);

% Take the predicted class for each case as the maximum probability class
% for that case
[~,predClasses] = max(predClassProbs,[],2);

% Compute confusion matrix
conf = getConfusion(predClasses,trueClasses);

% Compute precision and recall from the confusion matrix
%
% NOTE: You have to implement this function!
[prec, rec] = confToPrecRec(conf);