function model = initGridworld( paramSet )
% Creates a model based on the parameters.  Each cell is a state, numbered
% from 1...n across rows and then down columns.  For computational
% convenience, the obstructed states and goal state transition to a
% fictional absorbing end state.  
%
% The model output consists of:
% * model.P( s, s', a ) is the transition probability from s to s' given
% action a.  
% * model.R( s, a ) is the reward for performing a in s.
% * model.stateCount = number of states, including fictional end state

% set state count
% NOTE: the state count is ( number of grids +1 ). We add an extra state, to which the robot transitions whenever 
% it reaches home, or hits any of the trees. You can treat it as any normal state (why?).
% Helps in detecting end of simulation.
model.stateCount = paramSet.colCount * paramSet.rowCount + 1;
model.gamma = paramSet.gamma;

% set the rewards for each state
model.R = repmat( paramSet.rStep, model.stateCount,1 );
model.R( model.stateCount ) = 0;
goalState = rc2s( paramSet.goalState , paramSet.colCount );
model.R( goalState) = paramSet.rGoal;
for i = 1:size( paramSet.badSet , 1 )
    badState = rc2s( paramSet.badSet( i , : ) , paramSet.colCount );
    model.R( badState ) = paramSet.rBad;
end

% initialize the transition probabilities for each (s , s', a) to 0. %
% Note: You would want to initialize them as uniform probabilities. %
model.P = zeros( model.stateCount, model.stateCount, 4 ); 


        
        
        
