% Helper function to get the next state in the gridworld park. %
% DO NOT CHANGE %
function sout = getNextState(paramSet, stateCount, s , a)

% check if s is end state - self transition %
if s == stateCount
    sout = s;
    return;
end

% check if s is a goal or an obstructed state(trees) - transition to end %
rc = s2rc( s , paramSet.colCount );
endSet = [ paramSet.obsSet ; paramSet.goalState ];
if any( sum( abs( ...
        endSet - repmat( rc , size(endSet,1), 1 ...
        ) ) , 2 ) == 0 )
    sout = stateCount;
    return;
end

% else consider stochastic effects of action   %
r = rand(1,1);
if (r <0.15)
    ang = -1;
elseif (r <0.30)
    ang = 1;
else
    ang = 0;
end
dir = getDir( a , ang );
sout = getState( s , dir , paramSet );

% ---------------------------------------------------------------------- %
function sout = getState( s, dir , paramSet )
% takes in a state, direction, and gives deterministic result of action
cLUT = [0 0 -1 1];
rLUT = [-1 1 0 0];
rc = s2rc( s , paramSet.colCount );
rc(1) = rc(1) + rLUT( dir );
rc(2) = rc(2) + cLUT( dir );

% check if invalid state
if ( any( rc < 1 ) || ...
        any( rc(:,1) > paramSet.rowCount ) || ...
        any( rc(:,2) > paramSet.colCount ) )
    sout = s;

% else
else
    sout = rc2s( rc, paramSet.colCount );
end

% ---------------------------------------------------------------------- %
function dir = getDir( a, ang )
% takes in a direction and -1, 0, 1 and converts to another direction
leftLUT = [3 4 2 1];
rightLUT = [4 3 1 2];
if ang == 0
    dir = a;
elseif ang == -1
    dir = leftLUT( a );
elseif ang == 1;
    dir = rightLUT( a );
end

