#!/usr/bin/env python
#ROS imports
import roslib; roslib.load_manifest('hw_prob1')
import rospy
import tf
#imports to handle messages
from nav_msgs.msg import Odometry
from geometry_msgs.msg import Twist
from geometry_msgs.msg import Pose
from sensor_msgs.msg import LaserScan
from geometry_msgs.msg import Vector3
#other python stuff
import math

#distance to object in front of robot
wallDistForward=0
#distance to object to the left of robot
wallDistLeft=0
#distance to object to the right of robot
wallDistRight=0

#robot's angular orientation
angle=0
#robot's x position
xPos=0
#robot's y position
yPos=0

#callback to store laser data
def recordLaser(data):
    global wallDistForward
    global wallDistLeft
    global wallDistRight
    #get numer of laser samples
    numAng=(data.angle_max-data.angle_min)/data.angle_increment
    wallDistForward=data.ranges[int(numAng/2)]
    wallDistRight=data.ranges[int(numAng/2)-360]
    wallDistLeft=data.ranges[int(numAng/2)+360]

#callback to store 0dometry data
def recordOdom(data):
    global angle
    global xPos
    global yPos
    xPos=data.pose.pose.position.x
    yPos=data.pose.pose.position.y
    #get Quaternion anglular information
    x=data.pose.pose.orientation.x
    y=data.pose.pose.orientation.y
    z=data.pose.pose.orientation.z
    w=data.pose.pose.orientation.w
    #convert to pitch
    angle=math.atan2(2*(y*x+w*z),w*w+x*x-y*y-z*z)

#controller method
def controller():
    #the callbacks earlier in the file will asynchronously update
    #these variables
    global wallDistForward
    global wallDistLeft
    global wallDistRight
    global angle
    global xPos
    global yPos
    #this allows us to publish commands for the robot
    pub=rospy.Publisher('cmd_vel',Twist)
    #init the node
    rospy.init_node('hw_prob1')
    #these start the threads that call the recordLaser and recordOdom when the data is ready
    rospy.Subscriber("base_scan", LaserScan, recordLaser)
    rospy.Subscriber("base_pose_ground_truth", Odometry, recordOdom)
    rospy.sleep(2)
    done =0

################################### MODIFY HERE #######################################################
    while not rospy.is_shutdown() and not done:      
        #print the location and laser data
        rospy.loginfo("Bot at x=%f y=%f ang=%f distance forward=%f left=%f right=%f",xPos,yPos,angle/math.pi*180,wallDistForward,wallDistLeft,wallDistRight)
        if angle>-math.pi/2:
            #turn right ie. turn clockwise at a rate of .1 rad/sec
            #cmd is made up of two vectors, the linear and angular velocity
            cmd=Twist(Vector3(0,0,0),Vector3(0,0,-.1))
        #while the robot still has more distance to travel keep going
        elif yPos>-4:      
            #move forward 
            cmd=Twist(Vector3(1,0,0),Vector3(0,0,0))
        else:            
            #stop the robot
            cmd=Twist(Vector3(0,0,0),Vector3(0,0,0))
            done=1
        pub.publish(cmd)
        rospy.sleep(.2)
#######################################################################################################

if __name__ == '__main__':
    try:
        controller()
    except rospy.ROSInterruptException: pass
