#include <ros/ros.h>
#include "geometry_msgs/Twist.h"
#include "nav_msgs/Odometry.h"
#include "sensor_msgs/LaserScan.h"
#include <std_msgs/String.h>
#include <sstream>
#include <math.h>
#include <time.h>

#define PI 3.14159265

//distance to object in front of robot
double wallDistForward=0;
//distance to object to the left of robot
double wallDistLeft=0;
//distance to object to the right of robot
double wallDistRight=0;


//callback to store laser data
void recordLaser(const sensor_msgs::LaserScan::ConstPtr& data){
    //get numer of laser samples
    double numAng=(data->angle_max-data->angle_min)/data->angle_increment;
    wallDistForward=data->ranges[(int)(numAng/2)];
    wallDistRight=data->ranges[(int)(numAng/2-360)];
    wallDistLeft=data->ranges[(int)(numAng/2+360)];
}

int main(int argc, char** argv)
{
  //init node
  ros::init(argc, argv, "controller");
  ros::NodeHandle n;
  //connect to topic "cmd_vel" to control robot velocity
  ros::Publisher pub = n.advertise<geometry_msgs::Twist>("cmd_vel", 100);
  //these start the threads that call the recordLaser and recordOdom when the data is ready
  ros::Subscriber sub_laser = n.subscribe("base_scan", 100, recordLaser);
  
  
//################################# MODIFY HERE #######################################################
  srand(time(NULL));

  //set up loop to run at 5Hz
  ros::Rate loop_rate(5);
  int done=0;
  while (ros::ok()&&!done)
  {
    geometry_msgs::Twist cmd;
    //make random movement

    cmd.linear.x=((double)rand()/((double)(RAND_MAX)+(double)(1)))*10.-5.;
    cmd.angular.z=((double)rand()/((double)(RAND_MAX)+(double)(1)))*2.-5.;   

   //send command
    pub.publish(cmd);
    //allow other threads a chance and wait for next loop iteration
    ros::spinOnce();
    loop_rate.sleep();

  }
  //#####################################################################################################



}

