#!/usr/bin/env python
#ROS imports
import roslib; roslib.load_manifest('localize_demo')
import rospy
#imports to handle messages
from sensor_msgs.msg import LaserScan
from geometry_msgs.msg import Twist
from geometry_msgs.msg import Vector3

#other python stuff
import math
import random

#distance to object in front of robot
wallDistForward=0
#distance to object to the left of robot
wallDistLeft=0
#distance to object to the right of robot
wallDistRight=0

#callback to store laser data
def recordLaser(data):
    global wallDistForward
    global wallDistLeft
    global wallDistRight
    #get numer of laser samples
    numAng=(data.angle_max-data.angle_min)/data.angle_increment
    wallDistForward=data.ranges[int(numAng/2)]
    wallDistRight=data.ranges[int(numAng/2)-360]
    wallDistLeft=data.ranges[int(numAng/2)+360]

#controller method
def controller():
    #the callbacks earlier in the file will asynchronously update
    #these variables
    global wallDistForward
    global wallDistLeft
    global wallDistRight
    #this allows us to publish commands for the robot
    pub=rospy.Publisher('cmd_vel',Twist)
    #init the node
    rospy.init_node('localize_demo')
    #these start the threads that call the recordLaser and recordOdom when the data is ready
    rospy.Subscriber("base_scan", LaserScan, recordLaser) 
    rospy.sleep(2)
    done =0

################################### MODIFY HERE #######################################################
    while not rospy.is_shutdown() and not done:
        cmd=Twist(Vector3(random.uniform(-5,5),0,0),Vector3(0,0,random.uniform(-1, 1)))
        pub.publish(cmd)
        rospy.sleep(.2)
#######################################################################################################

if __name__ == '__main__':
    try:
        controller()
    except rospy.ROSInterruptException: pass
