%This file controls the helicopter dynamics

function [h_true,ctrl] = heli(course)

DAMPING = .49;
SIGMA = .1;
h = 0;
v = 0;
a = 0;
h_meas = [0];
h_true = [];
ctrl = [];
newlift = 0; %used to add an extra one-step delay.  
t = 2:length(course);

for x = t
	h_meas = vertcat(h_meas,h+normrnd(0,SIGMA));
	h_true = vertcat(h_true,h);
	lift = newlift;
	newlift = control(h_meas,course(1:x));
	newlift = max(0,min(newlift,6000));
	ctrl = vertcat(ctrl,newlift);
	h = h+v;
	v = v+a;
	if (h<=0) v=max(0,v); h=0; end
	a = -.098 + .098*lift/2000 - DAMPING*v; 
end 


