#ifndef FEATURES_H
#define FEATURES_H

#include "ImageDatabase.h"
#include <opencv/cv.h>

struct ROCPoint
{
  float trueRate;
  float falseRate;
};


// Compute harris values of an image.
void computeMOPSValues ( IplImage * srcImage,
                         IplImage * destImage,
                         IplImage * orientationImage );

//  Compute local maximum of MOPS values in an image.
void computeLocalMaxima ( IplImage * srcImage, IplImage * destImage );

// Compute features of an image.
bool computeFeatures ( IplImage *   image,
                       FeatureSet & features,
                       int          featureType );

// Perform a query on the database.
bool performQuery ( const FeatureSet &     f1,
                    const ImageDatabase &  db,
                    size_t &                  bestIndex,
                    vector<FeatureMatch> & bestMatches,
                    float &                bestScore,
                    int                    matchType );

// Match one feature set with another.
bool matchFeatures ( const FeatureSet &     f,
                     const FeatureSet &     f2,
                     vector<FeatureMatch> & matches,
                     float &                totalScore,
                     int                    matchType );

// Add ROC curve data to the data vector
void addRocData ( const FeatureSet &f1,
                  const FeatureSet &f2,
                  const vector<FeatureMatch> &matches,
                  float h[9],
                  vector<bool> &isMatch,
                  float threshold,
                  float & maxD );

// Evaluate a match using a ground truth homography.
float evaluateMatch ( const FeatureSet &f1,
                      const FeatureSet &f2,
                      const vector<FeatureMatch> &matches,
                      float h[9] );

// Compute silly example features.
void dummyComputeFeatures ( IplImage * image, FeatureSet & features );

// Compute actual feature
void ComputeMOPSFeatures ( IplImage * image, FeatureSet & features );

// Perform ssd feature matching.
void ssdMatchFeatures ( const FeatureSet &     f1,
                        const FeatureSet &     f2,
                        vector<FeatureMatch> & matches,
                        float &                totalScore );

// Perform ratio feature matching.  You must implement this.
void ratioMatchFeatures ( const FeatureSet &     f1,
                          const FeatureSet &     f2,
                          vector<FeatureMatch> & matches,
                          float &                totalScore );

void convertToByteImage ( IplImage * floatImage, IplImage * byteImage );

// Compute SSD distance between two vectors.
float distanceSSD ( const vector<float> & v1, const vector<float> & v2 );

// Transform point by homography.
void applyHomography ( float x,
                       float y,
                       float & xNew,
                       float & yNew,
                       float h[9] );

// Computes points on the Roc curve
vector<ROCPoint> computeRocCurve ( vector<FeatureMatch> & matches,
                                   vector<bool> &         isMatch,
                                   vector<float> &        thresholds );

// Compute AUC given a ROC curve
float computeAUC ( vector<ROCPoint> & results );

#endif
