#ifndef PROCESS_IMAGE_H
#define PROCESS_IMAGE_H

#include <opencv/cv.h>
#include <string>
#include <map>

enum FilterImageFormat {BGR24, Gray, YUV24};

typedef void (* Filter) (IplImage *, int);
struct FilterData
{
    Filter ImageFilter;
    std::string Name;
    FilterImageFormat ImageFormat;
};

class Filters
{
    std::map <std::string, FilterData> filterMap;
    Filters ();
  public:
    FilterData GetFilter (const std::string &);
    FilterData GetFilter (size_t);
    static Filters & GetInstance ();
};

#endif
