#include "Filters.h"

// Student code goes in here
#include "Project1.cpp"
// End student code

Filters::Filters ()
{
    FilterData f1 = {gaussian, "gaussian", BGR24};
    filterMap [f1.Name] = f1;

    FilterData f2 = {sobel_x, "sobel_x", BGR24};
    filterMap [f2.Name] = f2;

    FilterData f3 = {sharpen, "sharpen", BGR24};
    filterMap [f3.Name] = f3;

    FilterData f4 = {median, "median", BGR24};
    filterMap [f4.Name] = f4;

    FilterData f5 = {sobel_y, "sobel_y", BGR24};
    filterMap [f5.Name] = f5;
}

Filters & Filters::GetInstance ()
{
  static Filters filters;
  return filters;
}

FilterData Filters::GetFilter (const std::string & filterName)
{
  return filterMap [filterName];
}

FilterData Filters::GetFilter (size_t filterNum)
{
  if (filterNum > filterMap.size())
  {
      throw std::exception();
  }
  std::map<std::string, FilterData>::iterator i;
  size_t j;
  for (i = filterMap.begin(), j = 1; j != filterNum; ++j, ++i);
  return i->second;
}
// filter function - generic
// specific filters
// gaussian
// sobel
// sharpen
// all these call filter function
// median of given size (parameter)
// fixed size for others
// gaussian 5x5
// sobel 3x3
// sharpen 3x3
// slider for median filter
// command line argument for median filter
// 

