#include "CameraWidget.h"
#include <QLayout>
#include <QSlider>
#include "OverlayWidget.h"
#include <QPushButton>
#include "CameraThread.h"

CameraWidget::CameraWidget (QWidget * parent):QWidget (parent)
{
    label = new QLabel (this);
    QHBoxLayout *layout = new QHBoxLayout;
    layout->setContentsMargins(0, 0, 0, 0);

    // Put a slider on the left
    QSlider *slider = new QSlider(Qt::Vertical, this);
    layout->addWidget(slider);
    slider->setMaximum (10);

    // Make an overlay for displaying viewfinder frames
    overlay = new OverlayWidget(this);
    overlay->setFixedSize(640, 480);
    layout->addWidget(overlay);

    // Make some buttons down the right
    QVBoxLayout *buttonLayout = new QVBoxLayout;
    layout->addLayout(buttonLayout);
    QPushButton *quitButton = new QPushButton("X");
    QPushButton *button1 = new QPushButton("1");
    QPushButton *button2 = new QPushButton("2");
    QPushButton *button3 = new QPushButton("3");
    QPushButton *button4 = new QPushButton("4");
    QPushButton *button5 = new QPushButton("5");
    quitButton->setFixedSize(80, 64);
    button1->setFixedSize(80, 64);
    button2->setFixedSize(80, 64);
    button3->setFixedSize(80, 64);
    button4->setFixedSize(80, 64);
    button5->setFixedSize(80, 64);
    buttonLayout->addWidget(quitButton);
    buttonLayout->addStretch(1);
    buttonLayout->addWidget(button1);
    buttonLayout->addWidget(button2);
    buttonLayout->addWidget(button3);
    buttonLayout->addWidget(button4);
    buttonLayout->addWidget(button5);

    setLayout(layout);

    // Show the app full screen
    showFullScreen();

    // Make a thread that controls the camera
    cameraThread = new CameraThread(overlay);

    // Hook up the quit button to stop the camera thread
    QObject::connect(quitButton, SIGNAL(clicked()),
                     cameraThread, SLOT(stop()));

    QObject::connect(button1, SIGNAL(clicked()),
                     this, SLOT(start_filter1()));

    QObject::connect(button2, SIGNAL(clicked()),
                     this, SLOT(start_filter2()));

    QObject::connect(button3, SIGNAL(clicked()),
                     this, SLOT(start_filter3()));

    QObject::connect(button4, SIGNAL(clicked()),
                     this, SLOT(start_filter4()));

    QObject::connect(button5, SIGNAL(clicked()),
                     this, SLOT(start_filter5()));
    
    QObject::connect(button1, SIGNAL(clicked()),
                     cameraThread, SLOT(start_filter1()));

    QObject::connect(button2, SIGNAL(clicked()),
                     cameraThread, SLOT(start_filter2()));

    QObject::connect(button3, SIGNAL(clicked()),
                     cameraThread, SLOT(start_filter3()));

    QObject::connect(button4, SIGNAL(clicked()),
                     cameraThread, SLOT(start_filter4()));

    QObject::connect(button5, SIGNAL(clicked()),
                     cameraThread, SLOT(start_filter5()));

    QObject::connect(slider, SIGNAL(valueChanged (int)),
                     cameraThread, SLOT(parameter_change (int)));

    // Once the camera thread stops, quit the app
    QObject::connect(cameraThread, SIGNAL(finished()),
                     this, SLOT(close()));

    // Launch the camera thread
    cameraThread->start();

    start_filter1();
}

void CameraWidget::start_filter1()
{
    overlay->setText(Filters::GetInstance().GetFilter(1).Name);
}

void CameraWidget::start_filter2()
{
    overlay->setText(Filters::GetInstance().GetFilter(2).Name);
}

void CameraWidget::start_filter3()
{
    overlay->setText(Filters::GetInstance().GetFilter(3).Name);
}

void CameraWidget::start_filter4()
{
    overlay->setText(Filters::GetInstance().GetFilter(4).Name);
}

void CameraWidget::start_filter5()
{
    overlay->setText(Filters::GetInstance().GetFilter(5).Name);
}
