package pipeline.triangle;

import javax.vecmath.Color3f;
import javax.vecmath.Vector2f;
import javax.vecmath.Vector3f;

import pipeline.Pipeline;
import pipeline.math.Matrix4f;
import pipeline.misc.Vertex;



/**
 * Sets each vertex up with a constant color, no matter what the viewing
 * conditions. 
 * @author ags
 */
public class ConstColorTP extends TriangleProcessor {
    
    /** This is the composed modelling, viewing, projection, and viewport matrix. */
    protected Matrix4f m = new Matrix4f();

    /**
     * @see TriangleProcessor#nAttr()
     */
    public int nAttr() {
        return 3;
	}
    
    /**
     * @see TriangleProcessor#updateTransforms(Pipeline)
     */
    public void updateTransforms(Pipeline pipe) {
        m.set(pipe.modelviewMatrix);
        m.leftCompose(pipe.projectionMatrix);
        m.leftCompose(pipe.viewportMatrix);
    }
    
    /**
     * @see TriangleProcessor#triangle(Vector3f[], Color3f[], Vector3f[], Vector2f[], Vertex[])
     */
    public void triangle(Vector3f[] v, Color3f[] c, Vector3f[] n_ign, Vector2f[] t, Vertex[] output) {
        for (int k = 0; k < 3; k++) {
            output[k].v.set(v[k].x, v[k].y, v[k].z, 1);
            m.rightMultiply(output[k].v);
        }
        
        for (int k = 0; k < 3; k++) {
            output[k].setAttrs(nAttr());
            output[k].attrs[0] = c[2].x;
            output[k].attrs[1] = c[2].y;
            output[k].attrs[2] = c[2].z;
        }
    }

}