package resample.image;


/**
 * This image class additionally supports a resizing operation.  Resizing the image will
 * have two different effects depending on the current internal state of the image.  If 
 * the current data array is not large enough to hold the new image size, a new data array
 * large enough is allocated and it replaces the current array.  Otherwise, a new data array 
 * is not allocated and the a prefix of the current data array is used for the resized image.
 * Size the data array is not always recreated, the resize operation should generally be fast
 * (except for the first few resizes where the data array grows out to fill the largest size),
 * but the image data array will contain garbage after a resize call.  This means that you must
 * either explicitly fill the image with new data after the resize or you must clear() the data
 * to assure that the image is valid.
 * 
 * @author arbree
 * Sep 3, 2005
 * ResizableImage.java
 * Copyright 2005 Program of Computer Graphics, Cornell University
 */
public class ResizableImage extends Image {

  /**
   * Creates a new image, just calls Image().
   * @param inW
   * @param inH
   */
  public ResizableImage(int inW, int inH) {

    super(inW, inH);
    
  }

  /**
   * Image copy always creates a new array.
   * @param oldImage
   */
  public ResizableImage(Image oldImage) {

    super(oldImage);
    
  }
  
  /**
   * Resizes the image.  See the description in the class header.
   * @param newWidth the new width
   * @param newHeight the new height
   */
  public void resize(int newWidth, int newHeight) {

    //Set the image size
    int newSize = 3*newWidth*newHeight;
    width = newWidth;
    height = newHeight;
    
    //Grow array if necessary
    if(data.length < newSize)
      data = new float[newSize];
    
  }
}
