/*
 * Created on Sep 9, 2005
 * Copyright 2005 Program of Computer Grpahics, Cornell University
 */
package resample.discrete;

import resample.DiscreteFilter;


/**
 * @author arbree
 * Sep 9, 2005
 * UnsharpMaskFilter.java
 * Copyright 2005 Program of Computer Graphics, Cornell University
 */
public class UnsharpMaskFilter extends DiscreteFilter {
	
	/** The weight between the filters */
	public double alpha = 0.5;
	
	/** The cutoff of the Gaussian */
	private static final double CUTOFF = 3.0;
	
	/** The sigma of the Gaussian */
	public double sigma = 1.0;
	
	protected String[] getOptionsFields() {
		return new String[] {"alpha", "sigma"};
	}
	
	public String toString() {
		return "Discrete Unsharp Mask Filter";
	}
}
