package resample.continuous;

import resample.ContinuousFilter;
import resample.image.Color;
import resample.image.Image;

public class NearestNeighborFilter extends ContinuousFilter {
	
	public void resampleImage(Image input, Image output) {	
		quickResample(input, output);
	}

	public static void quickResample(Image input, Image output) {
		int newWidth = output.getWidth();
		int newHeight = output.getHeight();
		
		int oldWidth = input.getWidth();
		int oldHeight = input.getHeight();
		
		Color pixelColor = new Color();
		for (int numY = 0; numY < newHeight * oldHeight; numY += oldHeight) {
			for (int numX = 0; numX < newWidth * oldWidth; numX += oldWidth) {
				input.getPixelColor(pixelColor, numX / newWidth, numY / newHeight);
				output.setPixelColor(pixelColor, numX / oldWidth, numY / oldHeight);
			}
		}
	}
	
	public String toString() {
		return "Nearest Neighbor Resampling";
	}
	
}
