package modeler;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;

import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingConstants;

import modeler.shape.BezierRotation;

public class EditSplineDialog extends JDialog implements ActionListener {

  private static final long serialVersionUID = 1L;

  protected static final String OK_BUTTON_TEXT = "Ok";

  protected MainFrame frame;

  // The size of the drawing canvas is constant, for the sake of simplicity.
  protected static final int CANV_WIDTH = 500, CANV_HEIGHT = 500;

  protected SplineEditingPanel canvas;
  protected BezierRotation bezier;
  protected KeyAdapter keyAdapter;

  /**
   * Creates a spline editing dialog
   * @param newFrame
   * @param newTransformationTree
   * @param newBezier
   */
  public EditSplineDialog(MainFrame newFrame, BezierRotation newBezier) {

    super(newFrame, "Spline Editor", false);
    setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);

    frame = newFrame;

    Container cp = getContentPane();
    cp.setLayout(new BorderLayout());

    cp.add(createCenterPanel(), BorderLayout.CENTER);
    cp.add(createSouthPanel(), BorderLayout.SOUTH);

    packAndCenter();
    setBezier(newBezier);

    addKeyListener(keyAdapter);
    setResizable(false);
    pack();
  }

  public static JComponent addLabelLeft(JComponent c, String s) {

    JPanel toReturn = new JPanel(new BorderLayout());
    JLabel l = new JLabel(s);
    l.setHorizontalAlignment(SwingConstants.RIGHT);
    toReturn.add(l, BorderLayout.WEST);
    toReturn.add(c, BorderLayout.CENTER);
    return toReturn;
  }

  protected JComponent createSouthPanel() {

    JPanel toReturn = new JPanel();
    JButton temp;

    JLabel lbl = new JLabel("Render Mode: ");
    lbl.setHorizontalTextPosition(JLabel.RIGHT);
    toReturn.add(lbl);
    
    JComboBox box = new JComboBox(new String[] {"None", "Distance", "Flat"});
    box.addActionListener(this);
    toReturn.add(box);
    
    temp = new JButton(OK_BUTTON_TEXT);
    temp.addActionListener(this);
    toReturn.add(temp);

    return toReturn;
  }

  protected JComponent createCenterPanel() {

    JPanel toReturn = new JPanel(new BorderLayout());

    canvas = new SplineEditingPanel(new Dimension(CANV_WIDTH, CANV_HEIGHT), frame);
    canvas.addKeyListener(keyAdapter);
    toReturn.add(canvas, BorderLayout.CENTER);

    return toReturn;
  }

  protected void setBezier(BezierRotation newBezier) {

    bezier = newBezier;
    canvas.setBezier(newBezier);
    
  }

  protected void updateObject() {

    frame.refresh();
    
  }

  public void actionPerformed(ActionEvent e) {

    //Update display mode
    if(e.getSource() instanceof JComboBox) {
      
      canvas.setDebugMode(((JComboBox) e.getSource()).getSelectedIndex());
      return;
      
    }
    
    //Handle buttons
    String cmd = e.getActionCommand();
    if (cmd == null) {
      return;
    }
    else if (cmd.equals(OK_BUTTON_TEXT)) {
      updateObject();
      dispose();
    }
  }

  protected void packAndCenter() {

    pack();
    setLocation(frame.getX() + frame.getWidth() / 2 - getWidth() / 2, frame.getY() + frame.getHeight() / 2 - getHeight() / 2);
  }

  public void dispose() {

    frame.refresh();
    super.dispose();
    
  }

}
